/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.crawl;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import ucar.nc2.util.CancelTask;

public class CatalogCrawler {
    public static final int USE_ALL = 0;
    public static final int USE_ALL_DIRECT = 1;
    public static final int USE_FIRST_DIRECT = 2;
    public static final int USE_RANDOM_DIRECT = 3;
    public static final int USE_RANDOM_DIRECT_NOT_FIRST_OR_LAST = 4;
    private Filter filter = null;
    private Type type = Type.all;
    private Listener listen;
    private Random random;
    private int countCatrefs;

    public CatalogCrawler(int type, boolean skipDatasetScan, Listener listen) {
        this(Type.values()[type], new FilterDatasetScan(skipDatasetScan), listen);
    }

    public CatalogCrawler(Type type, Filter filter, Listener listen) {
        this.type = type;
        this.filter = filter;
        this.listen = listen;
        if (type == Type.random_direct || type == Type.random_direct_middle) {
            this.random = new Random(System.currentTimeMillis());
        }
    }

    public int crawl(String catUrl, CancelTask task, PrintWriter out, Object context) {
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
        InvCatalogImpl cat = catFactory.readXML(catUrl);
        StringBuilder buff = new StringBuilder();
        boolean isValid = cat.check(buff, false);
        if (out != null) {
            out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
            out.println(" validation output=\n" + buff);
        }
        if (isValid) {
            return this.crawl(cat, task, out, context);
        }
        return 0;
    }

    public int crawl(InvCatalogImpl cat, CancelTask task, PrintWriter out, Object context) {
        if (out != null) {
            out.println("***CATALOG " + cat.getCreateFrom());
        }
        this.countCatrefs = 0;
        for (InvDataset ds : cat.getDatasets()) {
            if (this.type == Type.all) {
                this.crawlDataset(ds, task, out, context, true);
            } else {
                this.crawlDirectDatasets(ds, task, out, context, true);
            }
            if (task == null || !task.isCancel()) continue;
            break;
        }
        return 1 + this.countCatrefs;
    }

    public void crawlDataset(InvDataset ds, CancelTask task, PrintWriter out, Object context, boolean release) {
        Object catref;
        boolean isDataScan;
        boolean isCatRef = ds instanceof InvCatalogRef;
        if (this.filter != null && this.filter.skipAll(ds)) {
            if (isCatRef && release) {
                ((InvCatalogRef)ds).release();
            }
            return;
        }
        boolean bl = isDataScan = ds.findProperty("DatasetScan") != null;
        if (isCatRef) {
            InvCatalogRef catref2 = (InvCatalogRef)ds;
            if (out != null) {
                out.println(" **CATREF " + catref2.getURI() + " (" + ds.getName() + ") ");
            }
            ++this.countCatrefs;
            if (!this.listen.getCatalogRef(catref2, context)) {
                if (release) {
                    catref2.release();
                }
                return;
            }
        }
        if (!isCatRef || isDataScan) {
            this.listen.getDataset(ds, context);
        }
        List<InvDataset> dlist = ds.getDatasets();
        if (isCatRef) {
            catref = (InvCatalogRef)ds;
            if (!isDataScan) {
                this.listen.getDataset(((InvCatalogRef)catref).getProxyDataset(), context);
            }
        }
        for (InvDataset dds : dlist) {
            this.crawlDataset(dds, task, out, context, release);
            if (task == null || !task.isCancel()) continue;
            break;
        }
        if (isCatRef && release) {
            catref = (InvCatalogRef)ds;
            ((InvCatalogRef)catref).release();
        }
    }

    public void crawlDirectDatasets(InvDataset ds, CancelTask task, PrintWriter out, Object context, boolean release) {
        boolean isCatRef = ds instanceof InvCatalogRef;
        if (this.filter != null && this.filter.skipAll(ds)) {
            if (isCatRef && release) {
                ((InvCatalogRef)ds).release();
            }
            return;
        }
        if (isCatRef) {
            InvCatalogRef catref = (InvCatalogRef)ds;
            if (out != null) {
                out.println(" **CATREF " + catref.getURI() + " (" + ds.getName() + ") ");
            }
            ++this.countCatrefs;
            if (!this.listen.getCatalogRef(catref, context)) {
                if (release) {
                    catref.release();
                }
                return;
            }
        }
        List<InvDataset> dlist = ds.getDatasets();
        ArrayList<InvDataset> leaves = new ArrayList<InvDataset>();
        for (InvDataset dds : dlist) {
            if (!dds.hasAccess()) continue;
            leaves.add(dds);
        }
        if (leaves.size() > 0) {
            if (this.type == Type.first_direct) {
                Iterator dds = (InvDataset)leaves.get(0);
                this.listen.getDataset((InvDataset)((Object)dds), context);
            } else if (this.type == Type.random_direct) {
                this.listen.getDataset(this.chooseRandom(leaves), context);
            } else if (this.type == Type.random_direct_middle) {
                this.listen.getDataset(this.chooseRandomNotFirstOrLast(leaves), context);
            } else {
                for (InvDataset dds : leaves) {
                    this.listen.getDataset(dds, context);
                    if (task == null || !task.isCancel()) continue;
                    break;
                }
            }
        }
        for (InvDataset dds : dlist) {
            if (dds.hasNestedDatasets()) {
                this.crawlDirectDatasets(dds, task, out, context, release);
            }
            if (task == null || !task.isCancel()) continue;
            break;
        }
        if (ds instanceof InvCatalogRef && release) {
            InvCatalogRef catref = (InvCatalogRef)ds;
            catref.release();
        }
    }

    private InvDataset chooseRandom(List datasets) {
        int index = this.random.nextInt(datasets.size());
        return (InvDataset)datasets.get(index);
    }

    private InvDataset chooseRandomNotFirstOrLast(List datasets) {
        int index = this.random.nextInt(datasets.size());
        if (index == 0 && datasets.size() > 1) {
            ++index;
        } else if (index == datasets.size() - 1 && datasets.size() > 1) {
            --index;
        }
        return (InvDataset)datasets.get(index);
    }

    private static class FilterDatasetScan
    implements Filter {
        boolean skipDatasetScan;

        private FilterDatasetScan(boolean skipDatasetScan) {
            this.skipDatasetScan = skipDatasetScan;
        }

        @Override
        public boolean skipAll(InvDataset ds) {
            return this.skipDatasetScan && ds instanceof InvCatalogRef && ds.findProperty("DatasetScan") != null;
        }
    }

    public static interface Filter {
        public boolean skipAll(InvDataset var1);
    }

    public static interface Listener {
        public void getDataset(InvDataset var1, Object var2);

        public boolean getCatalogRef(InvCatalogRef var1, Object var2);
    }

    public static enum Type {
        all,
        all_direct,
        first_direct,
        random_direct,
        random_direct_middle;

    }
}

