/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.builder.DatasetBuilder;

@Immutable
public class DatasetNode {
    protected final DatasetNode parent;
    protected final String name;
    protected final Map<String, Object> flds;

    protected DatasetNode(DatasetNode parent, String name, Map<String, Object> flds, List<DatasetBuilder> datasetBuilders) {
        this.parent = parent;
        this.name = name;
        this.flds = flds;
        if (datasetBuilders != null && datasetBuilders.size() > 0) {
            ArrayList<Dataset> datasets = new ArrayList<Dataset>(datasetBuilders.size());
            for (DatasetBuilder dsb : datasetBuilders) {
                datasets.add(dsb.makeDataset(this));
            }
            flds.put("Datasets", Collections.unmodifiableList(datasets));
        }
    }

    public Map<String, Object> getFlds() {
        return this.flds;
    }

    public DatasetNode getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public List<Dataset> getDatasets() {
        List datasets = (List)this.flds.get("Datasets");
        return datasets == null ? new ArrayList(0) : datasets;
    }

    public Dataset findDatasetByName(String name) {
        for (Dataset ds : this.getDatasets()) {
            if (!ds.getName().equals(name)) continue;
            return ds;
        }
        return null;
    }

    public boolean hasNestedDatasets() {
        List<Dataset> datasets = this.getDatasets();
        return !datasets.isEmpty();
    }

    public Catalog getParentCatalog() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof Catalog) {
            return (Catalog)this.parent;
        }
        return this.parent.getParentCatalog();
    }

    public Dataset getParentDataset() {
        if (this.parent == null) {
            return null;
        }
        return this.parent instanceof Dataset ? (Dataset)this.parent : null;
    }
}

