/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import java.util.zip.CRC32;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib2SectionProductDefinition {
    private final byte[] rawData;
    private final int templateNumber;

    public Grib2SectionProductDefinition(RandomAccessFile raf) throws IOException {
        long startingPosition = raf.getFilePointer();
        int length = GribNumbers.int4(raf);
        int section = raf.read();
        if (section != 4) {
            throw new IllegalArgumentException("Not a GRIB-2 PDS section");
        }
        raf.skipBytes(2);
        this.templateNumber = GribNumbers.int2(raf);
        this.rawData = new byte[length];
        raf.seek(startingPosition);
        raf.readFully(this.rawData);
    }

    public Grib2SectionProductDefinition(byte[] rawData) {
        this.rawData = rawData;
        this.templateNumber = GribNumbers.int2(this.getInt(8), this.getInt(9));
    }

    public byte[] getRawBytes() {
        return this.rawData;
    }

    public long calcCRC() {
        CRC32 crc32 = new CRC32();
        crc32.update(this.rawData);
        return crc32.getValue();
    }

    public int getLength() {
        return this.rawData.length;
    }

    public int getPDSTemplateNumber() {
        return this.templateNumber;
    }

    private int getInt(int index) {
        return this.rawData[index - 1] & 0xFF;
    }

    public Grib2Pds getPDS() {
        return Grib2Pds.factory(this.templateNumber, this.rawData);
    }
}

