/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.util.Formatter;
import java.util.HashSet;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.bufr.BufrConfig;
import ucar.nc2.iosp.bufr.Construct2;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageCompressedDataReader;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.MessageUncompressedDataReader;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.unidata.io.RandomAccessFile;

public class BufrIosp2
extends AbstractIOServiceProvider {
    private static final Logger log = LoggerFactory.getLogger(BufrIosp2.class);
    public static final String obsRecord = "obs";
    public static final String fxyAttName = "BUFR:TableB_descriptor";
    public static final String centerId = "BUFR:centerId";
    private static boolean debugIter = false;
    private Structure obsStructure;
    private Message protoMessage;
    private MessageScanner scanner;
    private HashSet<Integer> messHash = null;
    private boolean isSingle;
    private BufrConfig config;
    private Element iospParam;
    private int nelems = -1;

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugIter = debugFlag.isSet("Bufr/iter");
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return MessageScanner.isValidFile(raf);
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.scanner = new MessageScanner(raf);
        this.protoMessage = this.scanner.getFirstDataMessage();
        if (this.protoMessage == null) {
            throw new IOException("No data messages in the file= " + ncfile.getLocation());
        }
        if (!this.protoMessage.isTablesComplete()) {
            throw new IllegalStateException("BUFR file has incomplete tables");
        }
        this.config = BufrConfig.openFromMessage(raf, this.protoMessage, this.iospParam);
        Construct2 construct = new Construct2(this.protoMessage, this.config, ncfile);
        this.obsStructure = construct.getObsStructure();
        ncfile.finish();
        this.isSingle = false;
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, Message single) throws IOException {
        this.raf = raf;
        this.protoMessage = single;
        this.protoMessage.getRootDataDescriptor();
        if (!this.protoMessage.isTablesComplete()) {
            throw new IllegalStateException("BUFR file has incomplete tables");
        }
        BufrConfig config = BufrConfig.openFromMessage(raf, this.protoMessage, null);
        Construct2 construct = new Construct2(this.protoMessage, config, ncfile);
        this.obsStructure = construct.getObsStructure();
        this.isSingle = true;
        ncfile.finish();
    }

    @Override
    public Object sendIospMessage(Object message) {
        if (message instanceof Element) {
            this.iospParam = (Element)message;
            this.iospParam.detach();
            return true;
        }
        return super.sendIospMessage(message);
    }

    public BufrConfig getConfig() {
        return this.config;
    }

    public Element getElem() {
        return this.iospParam;
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        return new ArraySequence(this.obsStructure.makeStructureMembers(), new SeqIter(), this.nelems);
    }

    @Override
    public StructureDataIterator getStructureIterator(Structure s, int bufferSize) throws IOException {
        return this.isSingle ? new SeqIterSingle() : new SeqIter();
    }

    @Override
    public String getDetailInfo() {
        Formatter ff = new Formatter();
        ff.format("%s", super.getDetailInfo());
        this.protoMessage.dump(ff);
        ff.format("%n", new Object[0]);
        this.config.show(ff);
        return ff.toString();
    }

    @Override
    public String getFileTypeId() {
        return DataFormatType.BUFR.getDescription();
    }

    @Override
    public String getFileTypeDescription() {
        return "WMO Binary Universal Form";
    }

    private class SeqIterSingle
    implements StructureDataIterator {
        StructureDataIterator currIter;
        int recnum = 0;

        SeqIterSingle() {
            this.reset();
        }

        @Override
        public StructureDataIterator reset() {
            this.recnum = 0;
            this.currIter = null;
            return this;
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.currIter == null) {
                this.currIter = this.readProtoMessage();
                if (this.currIter == null) {
                    BufrIosp2.this.nelems = this.recnum;
                    return false;
                }
            }
            return this.currIter.hasNext();
        }

        @Override
        public StructureData next() throws IOException {
            ++this.recnum;
            return this.currIter.next();
        }

        private StructureDataIterator readProtoMessage() throws IOException {
            ArrayStructure as;
            Message m = BufrIosp2.this.protoMessage;
            if (m.dds.isCompressed()) {
                MessageCompressedDataReader reader = new MessageCompressedDataReader();
                as = reader.readEntireMessage(BufrIosp2.this.obsStructure, BufrIosp2.this.protoMessage, m, BufrIosp2.this.raf, null);
            } else {
                MessageUncompressedDataReader reader = new MessageUncompressedDataReader();
                as = reader.readEntireMessage(BufrIosp2.this.obsStructure, BufrIosp2.this.protoMessage, m, BufrIosp2.this.raf, null);
            }
            return as.getStructureDataIterator();
        }

        @Override
        public void setBufferSize(int bufferSize) {
            log.warn("Calling setBufferSize() on BUFR does nothing!");
        }

        @Override
        public int getCurrentRecno() {
            return this.recnum - 1;
        }

        @Override
        public void finish() {
            if (this.currIter != null) {
                this.currIter.finish();
            }
            this.currIter = null;
        }
    }

    private class SeqIter
    implements StructureDataIterator {
        StructureDataIterator currIter;
        int recnum = 0;

        SeqIter() {
            this.reset();
        }

        @Override
        public StructureDataIterator reset() {
            this.recnum = 0;
            this.currIter = null;
            BufrIosp2.this.scanner.reset();
            return this;
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.currIter == null) {
                this.currIter = this.readNextMessage();
                if (this.currIter == null) {
                    BufrIosp2.this.nelems = this.recnum;
                    return false;
                }
            }
            if (!this.currIter.hasNext()) {
                this.currIter = this.readNextMessage();
                return this.hasNext();
            }
            return true;
        }

        @Override
        public StructureData next() throws IOException {
            ++this.recnum;
            return this.currIter.next();
        }

        private StructureDataIterator readNextMessage() throws IOException {
            if (!BufrIosp2.this.scanner.hasNext()) {
                return null;
            }
            Message m = BufrIosp2.this.scanner.next();
            if (m == null) {
                log.warn("BUFR scanner hasNext() true but next() null!");
                return null;
            }
            if (m.containsBufrTable()) {
                return this.readNextMessage();
            }
            if (!BufrIosp2.this.protoMessage.equals(m)) {
                if (BufrIosp2.this.messHash == null) {
                    BufrIosp2.this.messHash = new HashSet(20);
                }
                if (!BufrIosp2.this.messHash.contains(m.hashCode())) {
                    log.warn("File " + BufrIosp2.this.raf.getLocation() + " has different BUFR message types hash=" + BufrIosp2.this.protoMessage.hashCode() + "; skipping");
                    BufrIosp2.this.messHash.add(m.hashCode());
                }
                return this.readNextMessage();
            }
            ArrayStructure as = this.readMessage(m);
            return as.getStructureDataIterator();
        }

        private ArrayStructure readMessage(Message m) throws IOException {
            ArrayStructure as;
            if (m.dds.isCompressed()) {
                MessageCompressedDataReader reader = new MessageCompressedDataReader();
                as = reader.readEntireMessage(BufrIosp2.this.obsStructure, BufrIosp2.this.protoMessage, m, BufrIosp2.this.raf, null);
            } else {
                MessageUncompressedDataReader reader = new MessageUncompressedDataReader();
                as = reader.readEntireMessage(BufrIosp2.this.obsStructure, BufrIosp2.this.protoMessage, m, BufrIosp2.this.raf, null);
            }
            return as;
        }

        @Override
        public void setBufferSize(int bufferSize) {
            log.warn("Calling setBufferSize() on BUFR does nothing!");
        }

        @Override
        public int getCurrentRecno() {
            return this.recnum - 1;
        }

        @Override
        public void finish() {
            if (this.currIter != null) {
                this.currIter.finish();
            }
            this.currIter = null;
            if (debugIter) {
                System.out.printf("BUFR read recnum %d%n", this.recnum);
            }
        }
    }
}

