/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import ucar.nc2.iosp.grid.GridParameter;
import ucar.unidata.util.StringUtil2;

public class GempakParameter
extends GridParameter {
    private int decimalScale = 0;
    private boolean isNumeric = true;

    public GempakParameter(int number, String name, String description, String unit, int scale) {
        this(number, name, description, unit, scale, true);
    }

    public GempakParameter(int number, String name, String description, String unit, int scale, boolean isNumeric) {
        super(number, name, description, unit);
        this.decimalScale = scale;
        this.isNumeric = isNumeric;
    }

    public int getDecimalScale() {
        return this.decimalScale;
    }

    public boolean getIsNumeric() {
        return this.isNumeric;
    }

    public void setIsNumeric(boolean yesorno) {
        this.isNumeric = yesorno;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("GridParameter: ");
        buf.append(StringUtil2.padLeft(String.valueOf(this.getNumber()), 4));
        buf.append(" ");
        String param = this.getName() + " (" + this.getDescription() + ")";
        buf.append(StringUtil2.padRight(param, 40));
        buf.append(" [");
        buf.append(this.getUnit());
        buf.append("]");
        buf.append(" scale: ");
        buf.append(this.getDecimalScale());
        return buf.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof GempakParameter)) {
            return false;
        }
        GempakParameter that = (GempakParameter)o;
        return super.equals(that) && this.decimalScale == that.decimalScale;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 17 * this.decimalScale;
    }
}

