/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.cache;

import java.util.Formatter;
import net.jcip.annotations.Immutable;
import ucar.nc2.util.Misc;

@Immutable
public class SmartArrayInt {
    private final int[] raw;
    private final int start;
    private final boolean isOrdered;
    private final boolean isConstant;
    private final int n;

    public SmartArrayInt(int[] raw) {
        this.n = raw.length;
        if (raw.length == 0) {
            this.start = -1;
            this.isOrdered = false;
            this.isConstant = true;
            this.raw = null;
            return;
        }
        boolean isO = true;
        boolean isC = true;
        this.start = raw[0];
        for (int i = 0; i < raw.length; ++i) {
            if (raw[i] != this.start + i) {
                isO = false;
            }
            if (raw[i] == this.start) continue;
            isC = false;
        }
        this.raw = !isO && !isC ? raw : null;
        this.isOrdered = isO;
        this.isConstant = isC;
    }

    public int get(int idx) {
        if (this.isConstant) {
            return this.start;
        }
        if (this.isOrdered) {
            return this.start + idx;
        }
        return this.raw[idx];
    }

    public int getN() {
        return this.n;
    }

    public void show(Formatter f) {
        if (this.isConstant) {
            f.format("isConstant=" + this.start, new Object[0]);
        } else if (this.isOrdered) {
            f.format("isOrdered start=" + this.start, new Object[0]);
        } else {
            Misc.showInts(this.raw, f);
        }
    }

    public int findIdx(int want) {
        if (this.isConstant) {
            return want == this.start ? 0 : -1;
        }
        if (this.isOrdered) {
            return want - this.start;
        }
        for (int i = 0; i < this.raw.length; ++i) {
            if (this.raw[i] != want) continue;
            return i;
        }
        return -1;
    }
}

