/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.auth;

import com.google.api.client.auth.oauth.OAuthHmacSigner;
import com.google.api.client.auth.oauth.OAuthSigner;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.datatransferproject.spi.api.auth.AuthServiceProviderRegistry;
import org.datatransferproject.types.common.models.DataVertical;

public interface OAuth1Config {
    public String getServiceName();

    public String getRequestTokenUrl();

    public String getAuthorizationUrl();

    public String getAccessTokenUrl();

    public List<DataVertical> getExportTypes();

    public List<DataVertical> getImportTypes();

    default public Map<String, String> getAdditionalUrlParameters(DataVertical dataType, AuthServiceProviderRegistry.AuthMode mode, OAuth1Step step) {
        return Collections.emptyMap();
    }

    default public OAuthSigner getRequestTokenSigner(String clientSecret) {
        OAuthHmacSigner signer = new OAuthHmacSigner();
        signer.clientSharedSecret = clientSecret;
        return signer;
    }

    default public OAuthSigner getAccessTokenSigner(String clientSecret, String tokenSecret) {
        OAuthHmacSigner signer = new OAuthHmacSigner();
        signer.clientSharedSecret = clientSecret;
        signer.tokenSharedSecret = tokenSecret;
        return signer;
    }

    public static enum OAuth1Step {
        REQUEST_TOKEN,
        AUTHORIZATION,
        ACCESS_TOKEN;

    }
}

