/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.datatransferproject.auth.OAuth2TokenResponse;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public interface OAuth2Config {
    public String getServiceName();

    public String getAuthUrl();

    public String getTokenUrl();

    public Map<DataVertical, Set<String>> getExportScopes();

    public Map<DataVertical, Set<String>> getImportScopes();

    default public Map<String, String> getAdditionalAuthUrlParameters() {
        return null;
    }

    default public TokensAndUrlAuthData getResponseClass(String result) throws IOException {
        OAuth2TokenResponse response = (OAuth2TokenResponse)new ObjectMapper().readValue(result, OAuth2TokenResponse.class);
        return new TokensAndUrlAuthData(response.getAccessToken(), response.getRefreshToken(), this.getTokenUrl());
    }
}

