/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.auth;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.utils.URIBuilder;
import org.datatransferproject.auth.OAuth2Config;
import org.datatransferproject.auth.OAuthUtils;
import org.datatransferproject.spi.api.auth.AuthDataGenerator;
import org.datatransferproject.spi.api.auth.AuthServiceProviderRegistry;
import org.datatransferproject.spi.api.types.AuthFlowConfiguration;
import org.datatransferproject.types.common.PortabilityCommon;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.AuthData;

public class OAuth2DataGenerator
implements AuthDataGenerator {
    private final OAuth2Config config;
    private final Set<String> scopes;
    private final String clientId;
    private final String clientSecret;
    private final HttpTransport httpTransport;

    OAuth2DataGenerator(OAuth2Config config, AppCredentials appCredentials, HttpTransport httpTransport, DataVertical dataType, AuthServiceProviderRegistry.AuthMode authMode) {
        this.config = config;
        this.validateConfig();
        this.clientId = appCredentials.getKey();
        this.clientSecret = appCredentials.getSecret();
        this.httpTransport = httpTransport;
        this.scopes = authMode == AuthServiceProviderRegistry.AuthMode.EXPORT ? config.getExportScopes().get(dataType) : config.getImportScopes().get(dataType);
    }

    public AuthFlowConfiguration generateConfiguration(String callbackBaseUrl, String id) {
        String encodedJobId = BaseEncoding.base64Url().encode(id.getBytes(StandardCharsets.UTF_8));
        String scope = this.scopes.isEmpty() ? "" : String.join((CharSequence)" ", this.scopes);
        try {
            URIBuilder builder = new URIBuilder(this.config.getAuthUrl()).setParameter("response_type", "code").setParameter("client_id", this.clientId).setParameter("redirect_uri", callbackBaseUrl).setParameter("scope", scope).setParameter("state", encodedJobId);
            if (this.config.getAdditionalAuthUrlParameters() != null) {
                for (Map.Entry<String, String> entry : this.config.getAdditionalAuthUrlParameters().entrySet()) {
                    builder.setParameter(entry.getKey(), entry.getValue());
                }
            }
            String url = builder.build().toString();
            return new AuthFlowConfiguration(url, PortabilityCommon.AuthProtocol.OAUTH_2, this.getTokenUrl());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Could not produce url.", e);
        }
    }

    public AuthData generateAuthData(String callbackBaseUrl, String authCode, String id, AuthData initialAuthData, String extra) {
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)extra), (Object)"Extra data not expected for OAuth flow");
        Preconditions.checkArgument((initialAuthData == null ? 1 : 0) != 0, (Object)("Initial auth data not expected for " + this.config.getServiceName()));
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("client_id", this.clientId);
        params.put("client_secret", this.clientSecret);
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", callbackBaseUrl);
        params.put("code", authCode);
        UrlEncodedContent content = new UrlEncodedContent(params);
        try {
            String tokenResponse = OAuthUtils.makeRawPostRequest(this.httpTransport, this.config.getTokenUrl(), (HttpContent)content);
            return this.config.getResponseClass(tokenResponse);
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting token", e);
        }
    }

    private void validateConfig() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.config.getServiceName()) ? 1 : 0) != 0, (Object)"Config is missing service name");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.config.getAuthUrl()) ? 1 : 0) != 0, (Object)"Config is missing auth url");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.config.getTokenUrl()) ? 1 : 0) != 0, (Object)"Config is missing token url");
        Preconditions.checkArgument((this.config.getExportScopes() != null ? 1 : 0) != 0, (Object)"Config is missing export scopes");
        Preconditions.checkArgument((this.config.getImportScopes() != null ? 1 : 0) != 0, (Object)"Config is missing import scopes");
    }
}

