/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.auth;

import com.google.api.client.http.HttpTransport;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.auth.OAuth1Config;
import org.datatransferproject.auth.OAuth1DataGenerator;
import org.datatransferproject.spi.api.auth.AuthDataGenerator;
import org.datatransferproject.spi.api.auth.AuthServiceProviderRegistry;
import org.datatransferproject.spi.api.auth.extension.AuthServiceExtension;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.transfer.auth.AppCredentials;

public class OAuth1ServiceExtension
implements AuthServiceExtension {
    private final OAuth1Config oAuth1Config;
    private volatile Map<DataVertical, OAuth1DataGenerator> exportAuthDataGenerators;
    private volatile Map<DataVertical, OAuth1DataGenerator> importAuthDataGenerators;
    private AppCredentials appCredentials;
    private HttpTransport httpTransport;
    private boolean initialized = false;
    private Monitor monitor;

    public OAuth1ServiceExtension(OAuth1Config oAuth1Config) {
        this.oAuth1Config = oAuth1Config;
    }

    public String getServiceId() {
        return this.oAuth1Config.getServiceName();
    }

    public AuthDataGenerator getAuthDataGenerator(DataVertical transferDataType, AuthServiceProviderRegistry.AuthMode mode) {
        return this.getOrCreateAuthDataGenerator(transferDataType, mode);
    }

    public List<DataVertical> getImportTypes() {
        return this.oAuth1Config.getImportTypes();
    }

    public List<DataVertical> getExportTypes() {
        return this.oAuth1Config.getExportTypes();
    }

    public void initialize(ExtensionContext context) {
        if (this.initialized) {
            return;
        }
        this.monitor = context.getMonitor();
        String serviceName = this.oAuth1Config.getServiceName().toUpperCase();
        String keyName = serviceName + "_KEY";
        String secretName = serviceName + "_SECRET";
        try {
            this.appCredentials = ((AppCredentialStore)context.getService(AppCredentialStore.class)).getAppCredentials(keyName, secretName);
        }
        catch (IOException e) {
            this.monitor.info(() -> String.format("Unable to retrieve OAuth1 AppCredentials. Did you set %s and %s?", keyName, secretName), new Object[]{e});
            return;
        }
        this.exportAuthDataGenerators = new HashMap<DataVertical, OAuth1DataGenerator>();
        this.importAuthDataGenerators = new HashMap<DataVertical, OAuth1DataGenerator>();
        this.httpTransport = (HttpTransport)context.getService(HttpTransport.class);
        this.initialized = true;
    }

    private synchronized OAuth1DataGenerator getOrCreateAuthDataGenerator(DataVertical transferType, AuthServiceProviderRegistry.AuthMode mode) {
        Map<DataVertical, OAuth1DataGenerator> generators;
        Preconditions.checkState((boolean)this.initialized, (Object)"Cannot get OAuth1DataGenerator before initialization");
        Preconditions.checkArgument((boolean)(mode == AuthServiceProviderRegistry.AuthMode.EXPORT ? this.getExportTypes().contains(transferType) : this.getImportTypes().contains(transferType)));
        Map<DataVertical, OAuth1DataGenerator> map = generators = mode == AuthServiceProviderRegistry.AuthMode.EXPORT ? this.exportAuthDataGenerators : this.importAuthDataGenerators;
        if (!generators.containsKey(transferType)) {
            generators.put(transferType, new OAuth1DataGenerator(this.oAuth1Config, this.appCredentials, this.httpTransport, transferType, mode, this.monitor));
        }
        return generators.get(transferType);
    }
}

