/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

class OAuthUtils {
    OAuthUtils() {
    }

    static String makeRawPostRequest(HttpTransport httpTransport, String url, HttpContent httpContent) throws IOException {
        HttpRequestFactory factory = httpTransport.createRequestFactory();
        HttpRequest postRequest = factory.buildPostRequest(new GenericUrl(url), httpContent);
        HttpResponse response = postRequest.execute();
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            throw new IOException("Bad status code: " + statusCode + " error: " + response.getStatusMessage());
        }
        return CharStreams.toString((Readable)new InputStreamReader(response.getContent(), StandardCharsets.UTF_8));
    }

    static <T> T makePostRequest(HttpTransport httpTransport, String url, HttpContent httpContent, Class<T> clazz) throws IOException {
        String result = OAuthUtils.makeRawPostRequest(httpTransport, url, httpContent);
        return (T)new ObjectMapper().readValue(result, clazz);
    }
}

