/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.auth;

import com.google.api.client.auth.oauth.OAuthAuthorizeTemporaryTokenUrl;
import com.google.api.client.auth.oauth.OAuthCredentialsResponse;
import com.google.api.client.auth.oauth.OAuthGetAccessToken;
import com.google.api.client.auth.oauth.OAuthGetTemporaryToken;
import com.google.api.client.http.HttpTransport;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.auth.OAuth1Config;
import org.datatransferproject.spi.api.auth.AuthDataGenerator;
import org.datatransferproject.spi.api.auth.AuthServiceProviderRegistry;
import org.datatransferproject.spi.api.types.AuthFlowConfiguration;
import org.datatransferproject.types.common.PortabilityCommon;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.AuthData;
import org.datatransferproject.types.transfer.auth.TokenSecretAuthData;

public class OAuth1DataGenerator
implements AuthDataGenerator {
    private static final String OUT_OF_BOUNDS_CALLBACK = "oob";
    private final OAuth1Config config;
    private final Monitor monitor;
    private final DataVertical dataType;
    private final AuthServiceProviderRegistry.AuthMode mode;
    private final String clientId;
    private final String clientSecret;
    private final HttpTransport httpTransport;

    OAuth1DataGenerator(OAuth1Config config, AppCredentials appCredentials, HttpTransport httpTransport, DataVertical datatype, AuthServiceProviderRegistry.AuthMode mode, Monitor monitor) {
        this.config = config;
        this.monitor = monitor;
        this.validateConfig();
        this.clientId = appCredentials.getKey();
        this.clientSecret = appCredentials.getSecret();
        this.httpTransport = httpTransport;
        this.dataType = datatype;
        this.mode = mode;
    }

    public AuthFlowConfiguration generateConfiguration(String callbackBaseUrl, String id) {
        TokenSecretAuthData authData;
        String callback = Strings.isNullOrEmpty((String)callbackBaseUrl) ? OUT_OF_BOUNDS_CALLBACK : callbackBaseUrl;
        OAuthGetTemporaryToken tempTokenRequest = new OAuthGetTemporaryToken(this.config.getRequestTokenUrl());
        tempTokenRequest.callback = callback;
        tempTokenRequest.transport = this.httpTransport;
        tempTokenRequest.consumerKey = this.clientId;
        tempTokenRequest.signer = this.config.getRequestTokenSigner(this.clientSecret);
        this.config.getAdditionalUrlParameters(this.dataType, this.mode, OAuth1Config.OAuth1Step.REQUEST_TOKEN).forEach((arg_0, arg_1) -> ((OAuthGetTemporaryToken)tempTokenRequest).set(arg_0, arg_1));
        try {
            OAuthCredentialsResponse tempTokenResponse = tempTokenRequest.execute();
            authData = new TokenSecretAuthData(tempTokenResponse.token, tempTokenResponse.tokenSecret);
        }
        catch (IOException e) {
            this.monitor.severe(() -> "Error retrieving request token", new Object[]{e});
            return null;
        }
        OAuthAuthorizeTemporaryTokenUrl authorizeUrl = new OAuthAuthorizeTemporaryTokenUrl(this.config.getAuthorizationUrl());
        authorizeUrl.temporaryToken = authData.getToken();
        this.config.getAdditionalUrlParameters(this.dataType, this.mode, OAuth1Config.OAuth1Step.AUTHORIZATION).forEach((arg_0, arg_1) -> ((OAuthAuthorizeTemporaryTokenUrl)authorizeUrl).set(arg_0, arg_1));
        String url = authorizeUrl.build();
        return new AuthFlowConfiguration(url, this.getTokenUrl(), PortabilityCommon.AuthProtocol.OAUTH_1, (AuthData)authData);
    }

    public AuthData generateAuthData(String callbackBaseUrl, String authCode, String id, AuthData initialAuthData, String extra) {
        TokenSecretAuthData accessToken;
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)extra), (Object)"Extra data not expected for OAuth flow");
        Preconditions.checkArgument((initialAuthData != null ? 1 : 0) != 0, (Object)("Initial auth data expected for " + this.config.getServiceName()));
        OAuthGetAccessToken accessTokenRequest = new OAuthGetAccessToken(this.config.getAccessTokenUrl());
        accessTokenRequest.transport = this.httpTransport;
        accessTokenRequest.temporaryToken = ((TokenSecretAuthData)initialAuthData).getToken();
        accessTokenRequest.consumerKey = this.clientId;
        accessTokenRequest.verifier = authCode;
        accessTokenRequest.signer = this.config.getAccessTokenSigner(this.clientSecret, ((TokenSecretAuthData)initialAuthData).getSecret());
        try {
            OAuthCredentialsResponse response = accessTokenRequest.execute();
            accessToken = new TokenSecretAuthData(response.token, response.tokenSecret);
        }
        catch (IOException e) {
            this.monitor.severe(() -> "Error retrieving request token", new Object[]{e});
            return null;
        }
        return accessToken;
    }

    private void validateConfig() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.config.getServiceName()) ? 1 : 0) != 0, (Object)"Config is missing service name");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.config.getRequestTokenUrl()) ? 1 : 0) != 0, (Object)"Config is missing request token url");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.config.getAuthorizationUrl()) ? 1 : 0) != 0, (Object)"Config is missing authorization url");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.config.getAccessTokenUrl()) ? 1 : 0) != 0, (Object)"Config is missing access token url");
    }
}

