/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.auth;

import com.google.api.client.http.HttpTransport;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.auth.OAuth2Config;
import org.datatransferproject.auth.OAuth2DataGenerator;
import org.datatransferproject.spi.api.auth.AuthDataGenerator;
import org.datatransferproject.spi.api.auth.AuthServiceProviderRegistry;
import org.datatransferproject.spi.api.auth.extension.AuthServiceExtension;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.transfer.auth.AppCredentials;

public class OAuth2ServiceExtension
implements AuthServiceExtension {
    private final OAuth2Config oAuth2Config;
    private volatile Map<DataVertical, OAuth2DataGenerator> exportAuthDataGenerators;
    private volatile Map<DataVertical, OAuth2DataGenerator> importAuthDataGenerators;
    private AppCredentials appCredentials;
    private HttpTransport httpTransport;
    private boolean initialized = false;

    public OAuth2ServiceExtension(OAuth2Config oAuth2Config) {
        this.oAuth2Config = oAuth2Config;
    }

    public String getServiceId() {
        return this.oAuth2Config.getServiceName();
    }

    public AuthDataGenerator getAuthDataGenerator(DataVertical transferDataType, AuthServiceProviderRegistry.AuthMode mode) {
        return this.getOrCreateAuthDataGenerator(transferDataType, mode);
    }

    public List<DataVertical> getImportTypes() {
        return new ArrayList<DataVertical>(this.oAuth2Config.getImportScopes().keySet());
    }

    public List<DataVertical> getExportTypes() {
        return new ArrayList<DataVertical>(this.oAuth2Config.getExportScopes().keySet());
    }

    public void initialize(ExtensionContext context) {
        if (this.initialized) {
            return;
        }
        String serviceName = this.oAuth2Config.getServiceName().toUpperCase();
        String keyName = serviceName + "_KEY";
        String secretName = serviceName + "_SECRET";
        try {
            this.appCredentials = ((AppCredentialStore)context.getService(AppCredentialStore.class)).getAppCredentials(keyName, secretName);
        }
        catch (IOException e) {
            Monitor monitor = context.getMonitor();
            monitor.info(() -> String.format("Unable to retrieve OAuth1 AppCredentials. Did you set %s and %s?", keyName, secretName), new Object[]{e});
            return;
        }
        this.importAuthDataGenerators = new HashMap<DataVertical, OAuth2DataGenerator>();
        this.exportAuthDataGenerators = new HashMap<DataVertical, OAuth2DataGenerator>();
        this.httpTransport = (HttpTransport)context.getService(HttpTransport.class);
        this.initialized = true;
    }

    private synchronized OAuth2DataGenerator getOrCreateAuthDataGenerator(DataVertical transferType, AuthServiceProviderRegistry.AuthMode mode) {
        Map<DataVertical, OAuth2DataGenerator> generators;
        Preconditions.checkState((boolean)this.initialized, (Object)"Cannot get OAuth2DataGenerator before initialization");
        Preconditions.checkArgument((boolean)(mode == AuthServiceProviderRegistry.AuthMode.EXPORT ? this.getExportTypes().contains(transferType) : this.getImportTypes().contains(transferType)));
        Map<DataVertical, OAuth2DataGenerator> map = generators = mode == AuthServiceProviderRegistry.AuthMode.EXPORT ? this.exportAuthDataGenerators : this.importAuthDataGenerators;
        if (!generators.containsKey(transferType)) {
            generators.put(transferType, new OAuth2DataGenerator(this.oAuth2Config, this.appCredentials, this.httpTransport, transferType, mode));
        }
        return generators.get(transferType);
    }
}

