/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.config;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.io.SequenceInputStream;

public class ConfigUtils {
    public static InputStream getCombinedInputStream(ImmutableList<String> settingsFiles) {
        return settingsFiles.stream().map(file -> ConfigUtils.class.getClassLoader().getResourceAsStream((String)file)).reduce(null, (in1, in2) -> ConfigUtils.combineStreams(in1, in2));
    }

    private static InputStream combineStreams(InputStream in1, InputStream in2) {
        if (in1 != null) {
            if (in2 != null) {
                return new SequenceInputStream(in1, in2);
            }
            return in1;
        }
        if (in2 != null) {
            return in2;
        }
        return null;
    }
}

