/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.launcher.monitor;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.function.Supplier;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.launcher.monitor.events.EventCode;

public class ConsoleMonitor
implements Monitor {
    private Level level;
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_BLACK = "\u001b[30m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_BLUE = "\u001b[34m";
    private boolean ansi;

    public ConsoleMonitor(Level level) {
        this.level = level;
        this.ansi = !System.getProperty("os.name").contains("Windows");
    }

    @Override
    public void severe(Supplier<String> supplier, Object ... data) {
        this.output("SEVERE", supplier, ANSI_RED, data);
    }

    @Override
    public void info(Supplier<String> supplier, Object ... data) {
        if (Level.INFO.value < this.level.value) {
            return;
        }
        this.output("INFO", supplier, ANSI_BLUE, data);
    }

    @Override
    public void debug(Supplier<String> supplier, Object ... data) {
        if (Level.DEBUG.value < this.level.value) {
            return;
        }
        this.output("DEBUG", supplier, ANSI_BLACK, data);
    }

    private void output(String level, Supplier<String> supplier, String color, Object ... data) {
        color = this.ansi ? color : "";
        String reset = this.ansi ? ANSI_RESET : "";
        String time = ZonedDateTime.now(ZoneId.systemDefault()).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        System.out.println(color + level + " " + time + " " + supplier.get() + reset);
        if (data != null) {
            for (Object datum : data) {
                if (datum instanceof Throwable) {
                    ((Throwable)datum).printStackTrace(System.out);
                    continue;
                }
                if (datum instanceof UUID) {
                    System.out.println("JobId: " + ((UUID)datum).toString());
                    continue;
                }
                if (datum instanceof EventCode) {
                    System.out.println("EventCode: " + datum.toString());
                    continue;
                }
                if (datum == null) continue;
                System.out.println(datum);
            }
        }
    }

    public static enum Level {
        SEVERE(2),
        INFO(1),
        DEBUG(0);

        int value;

        private Level(int value) {
            this.value = value;
        }
    }
}

