/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.launcher.monitor;

import java.util.ArrayList;
import java.util.ServiceLoader;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.api.launcher.MonitorExtension;
import org.datatransferproject.launcher.monitor.ConsoleMonitor;
import org.datatransferproject.launcher.monitor.MultiplexMonitor;

public class MonitorLoader {
    private static Monitor monitor;

    public static synchronized Monitor loadMonitor() {
        if (monitor == null) {
            try {
                ArrayList monitors = new ArrayList();
                ServiceLoader.load(MonitorExtension.class).iterator().forEachRemaining(extension -> {
                    try {
                        extension.initialize();
                        monitors.add(extension.getMonitor());
                    }
                    catch (Throwable e) {
                        System.out.println("Couldn't initialize: " + extension + ": " + e.getMessage());
                        e.printStackTrace(System.out);
                    }
                });
                if (monitors.isEmpty()) {
                    monitor = new ConsoleMonitor(ConsoleMonitor.Level.DEBUG);
                } else if (monitors.size() == 1) {
                    monitor = (Monitor)monitors.get(0);
                } else {
                    Monitor[] monitorArray = new Monitor[monitors.size()];
                    monitorArray = monitors.toArray(monitorArray);
                    monitor = new MultiplexMonitor(monitorArray);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
        }
        return monitor;
    }

    private MonitorLoader() {
    }
}

