/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.launcher.metrics;

import java.time.Duration;
import org.datatransferproject.api.launcher.DtpInternalMetricRecorder;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.types.common.models.DataVertical;

public class LoggingDtpInternalMetricRecorder
implements DtpInternalMetricRecorder {
    private final Monitor monitor;

    public static void registerRecorderIfNeeded(ExtensionContext context) {
        if (context.getService(DtpInternalMetricRecorder.class) == null) {
            context.registerService(DtpInternalMetricRecorder.class, new LoggingDtpInternalMetricRecorder(context.getMonitor()));
        }
    }

    private LoggingDtpInternalMetricRecorder(Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void startedJob(DataVertical dataType, String exportService, String importService) {
        this.monitor.debug(() -> String.format("Metric: StartedJob, data type: %s, from: %s, to: %s", dataType, exportService, importService), new Object[0]);
    }

    @Override
    public void exportPageAttemptFinished(DataVertical dataType, String service, boolean success, Duration duration) {
        this.monitor.debug(() -> String.format("Metric: exportPageAttemptFinished, data type: %s, service: %s, success: %s, duration: %s", dataType, service, success, duration), new Object[0]);
    }

    @Override
    public void exportPageFinished(DataVertical dataType, String service, boolean success, Duration duration) {
        this.monitor.debug(() -> String.format("Metric: exportPageFinished, data type: %s, service: %s, success: %s, duration: %s", dataType, service, success, duration), new Object[0]);
    }

    @Override
    public void importPageAttemptFinished(DataVertical dataType, String service, boolean success, Duration duration) {
        this.monitor.debug(() -> String.format("Metric: importPageAttemptFinished, data type: %s, service: %s,success: %s, duration: %s", dataType, service, success, duration), new Object[0]);
    }

    @Override
    public void importPageFinished(DataVertical dataType, String service, boolean success, Duration duration) {
        this.monitor.debug(() -> String.format("Metric: importPageFinished, data type: %s, service: %s, success: %s, duration: %s", dataType, service, success, duration), new Object[0]);
    }

    @Override
    public void finishedJob(DataVertical dataType, String exportService, String importService, boolean success, Duration duration) {
        this.monitor.debug(() -> String.format("Metric: finishedJob, data type: %s, from: %s, to: %s, success: %s, duration: %s", dataType, exportService, importService, success, duration), new Object[0]);
    }

    @Override
    public void cancelledJob(DataVertical dataType, String exportService, String importService, Duration duration) {
        this.monitor.debug(() -> String.format("Metric: cancelledJob, data type: %s, from: %s, to: %s, duration: %s", dataType, exportService, importService, duration), new Object[0]);
    }

    @Override
    public void recordGenericMetric(DataVertical dataType, String service, String tag) {
        this.monitor.debug(() -> String.format("Metric: Generic, data type: %s, service: %s, tag: %s", dataType, service, tag), new Object[0]);
    }

    @Override
    public void recordGenericMetric(DataVertical dataType, String service, String tag, boolean bool) {
        this.monitor.debug(() -> String.format("Metric: Generic, data type: %s, service: %s, tag: %s, value: %s", dataType, service, tag, bool), new Object[0]);
    }

    @Override
    public void recordGenericMetric(DataVertical dataType, String service, String tag, Duration duration) {
        this.monitor.debug(() -> String.format("Metric: Generic, data type: %s, service: %s, tag: %s, duration: %s", dataType, service, tag, duration), new Object[0]);
    }

    @Override
    public void recordGenericMetric(DataVertical dataType, String service, String tag, int value) {
        this.monitor.debug(() -> String.format("Metric: Generic, data type: %s, service: %s, tag: %s, value: %s", dataType, service, tag, value), new Object[0]);
    }
}

