/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.launcher.monitor;

import java.util.function.Supplier;
import org.datatransferproject.api.launcher.JobAwareMonitor;
import org.datatransferproject.api.launcher.Monitor;

public class MultiplexMonitor
implements JobAwareMonitor {
    private Monitor[] delegates;

    public MultiplexMonitor(Monitor ... delegates) {
        this.delegates = delegates != null ? delegates : new Monitor[]{};
    }

    @Override
    public void severe(Supplier<String> supplier, Object ... data) {
        for (Monitor delegate : this.delegates) {
            delegate.severe(supplier, data);
        }
    }

    @Override
    public void info(Supplier<String> supplier, Object ... data) {
        for (Monitor delegate : this.delegates) {
            delegate.info(supplier, data);
        }
    }

    @Override
    public void debug(Supplier<String> supplier, Object ... data) {
        for (Monitor delegate : this.delegates) {
            delegate.debug(supplier, data);
        }
    }

    @Override
    public void setJobId(String jobId) {
        for (Monitor delegate : this.delegates) {
            if (!(delegate instanceof JobAwareMonitor)) continue;
            ((JobAwareMonitor)delegate).setJobId(jobId);
        }
    }

    @Override
    public void flushLogs() {
        for (Monitor delegate : this.delegates) {
            delegate.flushLogs();
        }
    }
}

