/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.datatransferproject.api.launcher.Constants;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Flag;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.api.launcher.TypeManager;
import org.datatransferproject.config.extension.SettingsExtension;

public class ApiExtensionContext
implements ExtensionContext {
    private final Map<Class<?>, Object> registered = new HashMap();
    private final TypeManager typeManager;
    private final SettingsExtension settingsExtension;
    private final Monitor monitor;
    private final String cloud;
    private final Constants.Environment environment;
    private final String baseUrl;
    private final String baseApiUrl;

    public ApiExtensionContext(TypeManager typeManager, SettingsExtension settingsExtension, Monitor monitor) {
        this.typeManager = typeManager;
        this.settingsExtension = settingsExtension;
        this.monitor = monitor;
        this.registered.put(TypeManager.class, typeManager);
        this.cloud = (String)settingsExtension.getSetting("cloud", null);
        Preconditions.checkNotNull((Object)this.cloud, (Object)"Required setting 'cloud' is missing");
        this.environment = Constants.Environment.valueOf((String)((String)settingsExtension.getSetting("environment", null)));
        Preconditions.checkNotNull((Object)this.environment, (Object)"Required setting 'environment' is missing");
        this.baseUrl = (String)settingsExtension.getSetting("baseUrl", null);
        Preconditions.checkNotNull((Object)this.baseUrl, (Object)"Required setting 'baseUrl' is missing");
        this.baseApiUrl = (String)settingsExtension.getSetting("baseApiUrl", null);
        Preconditions.checkNotNull((Object)this.baseApiUrl, (Object)"Required setting 'baseApiUrl' is missing");
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public <T> T getService(Class<T> type) {
        return type.cast(this.registered.get(type));
    }

    public <T> void registerService(Class<T> type, T service) {
        this.registered.put(type, service);
    }

    public <T> T getSetting(String setting, T defaultValue) {
        return (T)this.settingsExtension.getSetting(setting, defaultValue);
    }

    @Flag
    public String cloud() {
        return this.cloud;
    }

    @Flag
    public Constants.Environment environment() {
        return this.environment;
    }

    @Flag
    public String baseUrl() {
        return this.baseUrl;
    }

    @Flag
    public String baseApiUrl() {
        return this.baseApiUrl;
    }
}

