/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.datatransferproject.api.ApiExtensionContext;
import org.datatransferproject.api.ApiServicesModule;
import org.datatransferproject.api.action.Action;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.api.launcher.SystemExtension;
import org.datatransferproject.api.launcher.TypeManager;
import org.datatransferproject.api.token.JWTTokenManager;
import org.datatransferproject.config.extension.SettingsExtension;
import org.datatransferproject.config.extension.SettingsExtensionLoader;
import org.datatransferproject.launcher.monitor.MonitorLoader;
import org.datatransferproject.launcher.types.TypeManagerImpl;
import org.datatransferproject.security.AesSymmetricKeyGenerator;
import org.datatransferproject.security.SymmetricKeyGenerator;
import org.datatransferproject.spi.api.auth.extension.AuthServiceExtension;
import org.datatransferproject.spi.api.transport.TransportBinder;
import org.datatransferproject.spi.cloud.extension.CloudExtension;
import org.datatransferproject.spi.cloud.extension.CloudExtensionLoader;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.service.extension.ServiceExtension;
import org.datatransferproject.types.transfer.auth.TokenAuthData;
import org.datatransferproject.types.transfer.auth.TokenSecretAuthData;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class ApiMain {
    private final Monitor monitor;
    private List<ServiceExtension> serviceExtensions = Collections.emptyList();

    public static void main(String[] args) {
        Monitor monitor = MonitorLoader.loadMonitor();
        monitor.info(() -> "Starting API Server.", new Object[0]);
        Thread.setDefaultUncaughtExceptionHandler((thread, t) -> monitor.severe(() -> "Uncaught exception in thread: " + thread.getName(), new Object[]{t}));
        ApiMain apiMain = new ApiMain(monitor);
        apiMain.initializeHttp();
        apiMain.start();
    }

    public ApiMain(Monitor monitor) {
        this.monitor = monitor;
    }

    public void initializeHttp() {
        this.initializeHttps(null, null, null);
    }

    public void initializeHttps(TrustManagerFactory trustManagerFactory, KeyManagerFactory keyManagerFactory, KeyStore keyStore) {
        Injector injector;
        JWTTokenManager tokenManager;
        TypeManagerImpl typeManager = new TypeManagerImpl();
        typeManager.registerTypes(new Class[]{TokenAuthData.class, TokensAndUrlAuthData.class, TokenSecretAuthData.class});
        SettingsExtension settingsExtension = SettingsExtensionLoader.getSettingsExtension();
        settingsExtension.initialize();
        ApiExtensionContext extensionContext = new ApiExtensionContext((TypeManager)typeManager, settingsExtension, this.monitor);
        if (trustManagerFactory != null) {
            extensionContext.registerService(TrustManagerFactory.class, trustManagerFactory);
        }
        if (keyManagerFactory != null) {
            extensionContext.registerService(KeyManagerFactory.class, keyManagerFactory);
        }
        if (keyStore != null) {
            extensionContext.registerService(KeyStore.class, keyStore);
        }
        extensionContext.registerService(HttpTransport.class, new NetHttpTransport());
        extensionContext.registerService(JsonFactory.class, new JacksonFactory());
        this.serviceExtensions = new ArrayList<ServiceExtension>();
        ServiceLoader.load(ServiceExtension.class).iterator().forEachRemaining(this.serviceExtensions::add);
        this.serviceExtensions.forEach(se -> se.initialize((ExtensionContext)extensionContext));
        CloudExtension cloudExtension = CloudExtensionLoader.getCloudExtension();
        cloudExtension.initialize((ExtensionContext)extensionContext);
        extensionContext.registerService(HttpTransport.class, new NetHttpTransport());
        extensionContext.registerService(JobStore.class, cloudExtension.getJobStore());
        extensionContext.registerService(TemporaryPerJobDataStore.class, cloudExtension.getJobStore());
        extensionContext.registerService(AppCredentialStore.class, cloudExtension.getAppCredentialStore());
        ArrayList<AuthServiceExtension> authServiceExtensions = new ArrayList<AuthServiceExtension>();
        ServiceLoader.load(AuthServiceExtension.class).iterator().forEachRemaining(authServiceExtension -> {
            authServiceExtension.initialize((ExtensionContext)extensionContext);
            authServiceExtensions.add((AuthServiceExtension)authServiceExtension);
        });
        AesSymmetricKeyGenerator keyGenerator = new AesSymmetricKeyGenerator(this.monitor);
        try {
            tokenManager = new JWTTokenManager(cloudExtension.getAppCredentialStore().getAppCredentials("JWT_KEY", "JWT_SECRET").getSecret(), this.monitor);
        }
        catch (IOException e) {
            this.monitor.info(() -> "Unable to initialize JWTTokenManager, did you specify a JWT_KEY and JWT_SECRET?", new Object[]{e});
            throw new RuntimeException("Couldn't initialize JWTTokenManager", e);
        }
        try {
            injector = Guice.createInjector((Module[])new Module[]{new ApiServicesModule((TypeManager)typeManager, cloudExtension.getJobStore(), (SymmetricKeyGenerator)keyGenerator, trustManagerFactory, keyManagerFactory, authServiceExtensions, tokenManager, extensionContext)});
        }
        catch (Exception e) {
            this.monitor.info(() -> "Error initializing Guice", new Object[]{e});
            throw e;
        }
        extensionContext.registerService(Injector.class, injector);
        this.bindActions(injector, extensionContext);
    }

    public void start() {
        this.serviceExtensions.forEach(SystemExtension::start);
    }

    public void stop() {
        this.serviceExtensions.forEach(SystemExtension::shutdown);
    }

    private void bindActions(Injector injector, ApiExtensionContext context) {
        TransportBinder binder = context.getService(TransportBinder.class);
        if (binder == null) {
            return;
        }
        TypeLiteral<Set<Action>> literal = ApiMain.setOf(Action.class);
        Key key = Key.get(literal);
        Set actions = (Set)injector.getInstance(key);
        actions.forEach(arg_0 -> ((TransportBinder)binder).bind(arg_0));
    }

    public static final <T> TypeLiteral<Set<T>> setOf(Class<T> type) {
        return TypeLiteral.get((Type)Types.setOf(type));
    }
}

