/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api.action;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import java.util.UUID;
import org.datatransferproject.types.common.models.DataVertical;

public final class ActionUtils {
    public static String encodeJobId(UUID jobId) {
        Preconditions.checkNotNull((Object)jobId);
        return BaseEncoding.base64Url().encode(jobId.toString().getBytes(Charsets.UTF_8));
    }

    public static UUID decodeJobId(String encodedJobId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)encodedJobId) ? 1 : 0) != 0);
        return UUID.fromString(new String(BaseEncoding.base64Url().decode((CharSequence)encodedJobId), Charsets.UTF_8));
    }

    public static boolean isValidTransferDataType(DataVertical transferDataType) {
        return transferDataType != null;
    }
}

