/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api.action.datatype;

import com.google.inject.Inject;
import java.util.Set;
import org.datatransferproject.api.action.Action;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.api.auth.AuthServiceProviderRegistry;
import org.datatransferproject.types.client.datatype.DataTypes;
import org.datatransferproject.types.client.datatype.GetDataTypes;

public final class DataTypesAction
implements Action<GetDataTypes, DataTypes> {
    private final AuthServiceProviderRegistry registry;
    private final Monitor monitor;

    @Inject
    DataTypesAction(AuthServiceProviderRegistry registry, Monitor monitor) {
        this.registry = registry;
        this.monitor = monitor;
    }

    public Class<GetDataTypes> getRequestType() {
        return GetDataTypes.class;
    }

    public DataTypes handle(GetDataTypes request) {
        Set transferDataTypes = this.registry.getTransferDataTypes();
        if (transferDataTypes.isEmpty()) {
            this.monitor.severe(() -> "No transfer data types were registered in " + AuthServiceProviderRegistry.class.getName(), new Object[0]);
        }
        return new DataTypes(transferDataTypes);
    }
}

