/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api.action.transfer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import javax.crypto.SecretKey;
import org.datatransferproject.api.action.Action;
import org.datatransferproject.api.action.ActionUtils;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.api.launcher.TypeManager;
import org.datatransferproject.launcher.monitor.events.EventCode;
import org.datatransferproject.security.EncrypterFactory;
import org.datatransferproject.security.SymmetricKeyGenerator;
import org.datatransferproject.spi.api.auth.AuthDataGenerator;
import org.datatransferproject.spi.api.auth.AuthServiceProviderRegistry;
import org.datatransferproject.spi.api.types.AuthFlowConfiguration;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.types.JobAuthorization;
import org.datatransferproject.spi.cloud.types.PortabilityJob;
import org.datatransferproject.types.client.transfer.CreateTransferJob;
import org.datatransferproject.types.client.transfer.TransferJob;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.models.DataVertical;

public class CreateTransferJobAction
implements Action<CreateTransferJob, TransferJob> {
    private final JobStore jobStore;
    private final AuthServiceProviderRegistry registry;
    private final SymmetricKeyGenerator symmetricKeyGenerator;
    private final ObjectMapper objectMapper;
    private final EncrypterFactory encrypterFactory;
    private final Monitor monitor;

    @Inject
    CreateTransferJobAction(JobStore jobStore, AuthServiceProviderRegistry registry, SymmetricKeyGenerator symmetricKeyGenerator, TypeManager typeManager, Monitor monitor) {
        this.jobStore = jobStore;
        this.registry = registry;
        this.symmetricKeyGenerator = symmetricKeyGenerator;
        this.objectMapper = typeManager.getMapper();
        this.encrypterFactory = new EncrypterFactory(monitor);
        this.monitor = monitor;
    }

    public Class<CreateTransferJob> getRequestType() {
        return CreateTransferJob.class;
    }

    public TransferJob handle(CreateTransferJob request) {
        PortabilityJob job;
        DataVertical dataType = request.getDataType();
        String exportService = request.getExportService();
        String importService = request.getImportService();
        Optional<ExportInformation> exportInformation = Optional.ofNullable(request.getExportInformation());
        String exportCallbackUrl = request.getExportCallbackUrl();
        String importCallbackUrl = request.getImportCallbackUrl();
        UUID jobId = UUID.randomUUID();
        SecretKey sessionKey = this.symmetricKeyGenerator.generate();
        String encodedSessionKey = BaseEncoding.base64Url().encode(sessionKey.getEncoded());
        String encryptionScheme = request.getEncryptionScheme();
        try {
            job = this.createJob(encodedSessionKey, dataType, exportService, importService, exportInformation, encryptionScheme);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't create job", e);
        }
        AuthDataGenerator exportGenerator = this.registry.getAuthDataGenerator(job.exportService(), job.transferDataType(), AuthServiceProviderRegistry.AuthMode.EXPORT);
        Preconditions.checkNotNull((Object)exportGenerator, (String)"Generator not found for type: %s, service: %s", (Object)job.transferDataType(), (Object)job.exportService());
        AuthDataGenerator importGenerator = this.registry.getAuthDataGenerator(job.importService(), job.transferDataType(), AuthServiceProviderRegistry.AuthMode.IMPORT);
        Preconditions.checkNotNull((Object)importGenerator, (String)"Generator not found for type: %s, service: %s", (Object)job.transferDataType(), (Object)job.importService());
        try {
            String encodedJobId = ActionUtils.encodeJobId(jobId);
            AuthFlowConfiguration exportConfiguration = exportGenerator.generateConfiguration(exportCallbackUrl, encodedJobId);
            AuthFlowConfiguration importConfiguration = importGenerator.generateConfiguration(importCallbackUrl, encodedJobId);
            job = this.setInitialAuthDataOnJob(sessionKey, job, exportConfiguration, importConfiguration);
            this.jobStore.createJob(jobId, job);
            this.monitor.debug(() -> String.format("Created new transfer of type '%s' from '%s' to '%s' with jobId: %s", dataType, exportService, importService, jobId), new Object[]{jobId, EventCode.API_JOB_CREATED});
            return new TransferJob(encodedJobId, job.exportService(), job.importService(), job.transferDataType(), exportConfiguration.getAuthUrl(), importConfiguration.getAuthUrl(), exportConfiguration.getTokenUrl(), importConfiguration.getTokenUrl(), exportConfiguration.getAuthProtocol(), importConfiguration.getAuthProtocol());
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't handle request", e);
        }
    }

    private PortabilityJob setInitialAuthDataOnJob(SecretKey sessionKey, PortabilityJob job, AuthFlowConfiguration exportConfiguration, AuthFlowConfiguration importConfiguration) throws JsonProcessingException {
        JobAuthorization updatedJobAuthorization;
        String encryptedInitialAuthData;
        String serialized;
        if (exportConfiguration.getInitialAuthData() != null) {
            Preconditions.checkState((boolean)Strings.isNullOrEmpty((String)job.jobAuthorization().encryptedInitialExportAuthData()));
            serialized = this.objectMapper.writeValueAsString((Object)exportConfiguration.getInitialAuthData());
            encryptedInitialAuthData = this.encrypterFactory.create(sessionKey).encrypt(serialized);
            updatedJobAuthorization = job.jobAuthorization().toBuilder().setEncryptedInitialExportAuthData(encryptedInitialAuthData).build();
            job = job.toBuilder().setAndValidateJobAuthorization(updatedJobAuthorization).build();
        }
        if (importConfiguration.getInitialAuthData() != null) {
            Preconditions.checkState((boolean)Strings.isNullOrEmpty((String)job.jobAuthorization().encryptedInitialImportAuthData()));
            serialized = this.objectMapper.writeValueAsString((Object)importConfiguration.getInitialAuthData());
            encryptedInitialAuthData = this.encrypterFactory.create(sessionKey).encrypt(serialized);
            updatedJobAuthorization = job.jobAuthorization().toBuilder().setEncryptedInitialImportAuthData(encryptedInitialAuthData).build();
            job = job.toBuilder().setAndValidateJobAuthorization(updatedJobAuthorization).build();
        }
        return job;
    }

    private PortabilityJob createJob(String encodedSessionKey, DataVertical dataType, String exportService, String importService, Optional<ExportInformation> exportInformation, String encryptionScheme) throws IOException {
        JobAuthorization jobAuthorization = JobAuthorization.builder().setSessionSecretKey(encodedSessionKey).setEncryptionScheme(encryptionScheme).setState(JobAuthorization.State.INITIAL).build();
        PortabilityJob.Builder builder = PortabilityJob.builder().setTransferDataType(dataType).setExportService(exportService).setImportService(importService).setAndValidateJobAuthorization(jobAuthorization);
        if (exportInformation.isPresent()) {
            builder.setExportInformation(this.objectMapper.writeValueAsString((Object)exportInformation.get()));
        }
        return builder.build();
    }
}

