/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api.action.transfer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.UUID;
import javax.crypto.SecretKey;
import org.datatransferproject.api.action.Action;
import org.datatransferproject.api.action.ActionUtils;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.api.launcher.TypeManager;
import org.datatransferproject.launcher.monitor.events.EventCode;
import org.datatransferproject.security.DecrypterFactory;
import org.datatransferproject.security.SymmetricKeyGenerator;
import org.datatransferproject.spi.api.auth.AuthDataGenerator;
import org.datatransferproject.spi.api.auth.AuthServiceProviderRegistry;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.types.PortabilityJob;
import org.datatransferproject.types.client.transfer.GenerateServiceAuthData;
import org.datatransferproject.types.client.transfer.ServiceAuthData;
import org.datatransferproject.types.transfer.auth.AuthData;

public class GenerateServiceAuthDataAction
implements Action<GenerateServiceAuthData, ServiceAuthData> {
    private JobStore jobStore;
    private final AuthServiceProviderRegistry registry;
    private final SymmetricKeyGenerator symmetricKeyGenerator;
    private final ObjectMapper objectMapper;
    private DecrypterFactory decrypterFactory;
    private final Monitor monitor;

    @Inject
    public GenerateServiceAuthDataAction(JobStore jobStore, AuthServiceProviderRegistry registry, SymmetricKeyGenerator symmetricKeyGenerator, TypeManager typeManager, Monitor monitor) {
        this.jobStore = jobStore;
        this.registry = registry;
        this.symmetricKeyGenerator = symmetricKeyGenerator;
        this.objectMapper = typeManager.getMapper();
        this.decrypterFactory = new DecrypterFactory(monitor);
        this.monitor = monitor;
    }

    public Class<GenerateServiceAuthData> getRequestType() {
        return GenerateServiceAuthData.class;
    }

    public ServiceAuthData handle(GenerateServiceAuthData request) {
        try {
            String encryptedInitialAuthData;
            String id = request.getId();
            Preconditions.checkNotNull((Object)id, (Object)"transfer job ID required for GenerateServiceAuthDataAction");
            UUID jobId = ActionUtils.decodeJobId(id);
            Preconditions.checkNotNull((Object)request.getAuthToken(), (String)"Auth token required for GenerateServiceAuthDataAction, transfer job ID: %s", (Object)jobId);
            PortabilityJob job = this.jobStore.findJob(jobId);
            Preconditions.checkNotNull((Object)job, (String)"existing job not found for transfer job ID: %s", (Object)jobId);
            AuthServiceProviderRegistry.AuthMode authMode = GenerateServiceAuthData.Mode.EXPORT == request.getMode() ? AuthServiceProviderRegistry.AuthMode.EXPORT : AuthServiceProviderRegistry.AuthMode.IMPORT;
            String service = authMode == AuthServiceProviderRegistry.AuthMode.EXPORT ? job.exportService() : job.importService();
            AuthDataGenerator generator = this.registry.getAuthDataGenerator(service, job.transferDataType(), authMode);
            String encodedSessionKey = job.jobAuthorization().sessionSecretKey();
            SecretKey key = this.symmetricKeyGenerator.parse(BaseEncoding.base64Url().decode((CharSequence)encodedSessionKey));
            AuthData initialAuthData = null;
            String string = encryptedInitialAuthData = authMode == AuthServiceProviderRegistry.AuthMode.EXPORT ? job.jobAuthorization().encryptedInitialExportAuthData() : job.jobAuthorization().encryptedInitialImportAuthData();
            if (encryptedInitialAuthData != null) {
                String serialized = this.decrypterFactory.create(key).decrypt(encryptedInitialAuthData);
                initialAuthData = (AuthData)this.objectMapper.readValue(serialized, AuthData.class);
            }
            AuthData authData = generator.generateAuthData(request.getCallbackUrl(), request.getAuthToken(), jobId.toString(), initialAuthData, null);
            Preconditions.checkNotNull((Object)authData, (Object)"Auth data should not be null");
            this.monitor.debug(() -> String.format("Generated auth data in mode '%s' for job: %s", authMode, jobId), new Object[]{jobId, EventCode.API_GENERATED_AUTH_DATA});
            String serialized = this.objectMapper.writeValueAsString((Object)authData);
            return new ServiceAuthData(serialized);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't handle request", e);
        }
    }
}

