/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api.action.transfer;

import com.google.api.client.util.Preconditions;
import com.google.inject.Inject;
import java.util.UUID;
import org.datatransferproject.api.action.Action;
import org.datatransferproject.api.action.ActionUtils;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.launcher.monitor.events.EventCode;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.types.JobAuthorization;
import org.datatransferproject.spi.cloud.types.PortabilityJob;
import org.datatransferproject.types.client.transfer.GetReservedWorker;
import org.datatransferproject.types.client.transfer.ReservedWorker;

public class GetReservedWorkerAction
implements Action<GetReservedWorker, ReservedWorker> {
    private final JobStore jobStore;
    private final Monitor monitor;

    @Inject
    public GetReservedWorkerAction(JobStore jobStore, Monitor monitor) {
        this.jobStore = jobStore;
        this.monitor = monitor;
    }

    public Class<GetReservedWorker> getRequestType() {
        return GetReservedWorker.class;
    }

    public ReservedWorker handle(GetReservedWorker workerRequest) {
        String id = workerRequest.getId();
        UUID jobId = ActionUtils.decodeJobId(id);
        PortabilityJob job = this.jobStore.findJob(jobId);
        Preconditions.checkNotNull((Object)job, (Object)("Couldn't lookup worker for job " + id + " because the job doesn't exist"));
        if (job.jobAuthorization().state() != JobAuthorization.State.CREDS_ENCRYPTION_KEY_GENERATED) {
            this.monitor.debug(() -> String.format("Job %s has not entered state CREDS_ENCRYPTION_KEY_GENERATED yet", jobId), new Object[]{jobId});
            return new ReservedWorker(null);
        }
        this.monitor.debug(() -> String.format("Got job %s in state CREDS_ENCRYPTION_KEY_GENERATED, returning its public key", jobId), new Object[]{jobId, EventCode.API_GOT_RESERVED_WORKER});
        return new ReservedWorker(job.jobAuthorization().authPublicKey());
    }
}

