/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api.action.transfer;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.UUID;
import org.datatransferproject.api.action.Action;
import org.datatransferproject.api.action.ActionUtils;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.launcher.monitor.events.EventCode;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.types.PortabilityJob;
import org.datatransferproject.types.client.transfer.GetTransferJob;
import org.datatransferproject.types.client.transfer.TransferJob;

public class GetTransferJobAction
implements Action<GetTransferJob, TransferJob> {
    private JobStore jobStore;
    private final Monitor monitor;

    @Inject
    public GetTransferJobAction(JobStore jobStore, Monitor monitor) {
        this.jobStore = jobStore;
        this.monitor = monitor;
    }

    public Class<GetTransferJob> getRequestType() {
        return GetTransferJob.class;
    }

    public TransferJob handle(GetTransferJob transferRequest) {
        String id = transferRequest.getId();
        Preconditions.checkNotNull((Object)id, (Object)"transfer job ID required for GetTransferJobAction");
        UUID jobId = ActionUtils.decodeJobId(id);
        PortabilityJob job = this.jobStore.findJob(jobId);
        this.monitor.debug(() -> String.format("Fetched job with jobId: %s", jobId), new Object[]{jobId, EventCode.API_GOT_TRANSFER_JOB});
        return new TransferJob(id, job.exportService(), job.importService(), job.transferDataType(), null, null, null, null, null, null);
    }
}

