/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api.action.transfer;

import com.google.inject.Inject;
import java.util.Set;
import org.datatransferproject.api.action.Action;
import org.datatransferproject.api.action.ActionUtils;
import org.datatransferproject.spi.api.auth.AuthServiceProviderRegistry;
import org.datatransferproject.types.client.transfer.GetTransferServices;
import org.datatransferproject.types.client.transfer.TransferServices;
import org.datatransferproject.types.common.models.DataVertical;

public final class GetTransferServicesAction
implements Action<GetTransferServices, TransferServices> {
    private final AuthServiceProviderRegistry registry;

    @Inject
    GetTransferServicesAction(AuthServiceProviderRegistry registry) {
        this.registry = registry;
    }

    public Class<GetTransferServices> getRequestType() {
        return GetTransferServices.class;
    }

    public TransferServices handle(GetTransferServices request) {
        DataVertical transferDataType = request.getTransferDataType();
        if (!ActionUtils.isValidTransferDataType(transferDataType)) {
            throw new IllegalArgumentException("Invalid transferDataType: " + transferDataType);
        }
        Set importServices = this.registry.getImportServices(transferDataType);
        Set exportServices = this.registry.getExportServices(transferDataType);
        if (importServices.isEmpty() || exportServices.isEmpty()) {
            throw new IllegalArgumentException("[" + transferDataType + "] does not have an import and export service");
        }
        return new TransferServices(transferDataType, exportServices, importServices);
    }
}

