/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api.action.transfer;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.UUID;
import org.datatransferproject.api.action.Action;
import org.datatransferproject.api.action.ActionUtils;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.launcher.monitor.events.EventCode;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.types.client.transfer.ReserveWorker;
import org.datatransferproject.types.client.transfer.ReservedWorker;

public class ReserveWorkerAction
implements Action<ReserveWorker, ReservedWorker> {
    private final JobStore jobStore;
    private final Monitor monitor;

    @Inject
    ReserveWorkerAction(JobStore jobStore, Monitor monitor) {
        this.jobStore = jobStore;
        this.monitor = monitor;
    }

    public Class<ReserveWorker> getRequestType() {
        return ReserveWorker.class;
    }

    public ReservedWorker handle(ReserveWorker reserveWorker) {
        String id = reserveWorker.getId();
        Preconditions.checkNotNull((Object)id, (Object)"transfer job ID required for ReserveWorkerAction");
        UUID jobId = ActionUtils.decodeJobId(id);
        this.updateStateToCredsAvailable(jobId);
        return new ReservedWorker("");
    }

    private void updateStateToCredsAvailable(UUID jobId) {
        try {
            this.jobStore.updateJobAuthStateToCredsAvailable(jobId);
            this.monitor.debug(() -> String.format("Updated job %s to CREDS_AVAILABLE", jobId), new Object[]{jobId, EventCode.API_JOB_CREDS_AVAILABLE});
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to update job", e);
        }
    }
}

