/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api.action.transfer;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.UUID;
import org.datatransferproject.api.action.Action;
import org.datatransferproject.api.action.ActionUtils;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.launcher.monitor.events.EventCode;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.types.JobAuthorization;
import org.datatransferproject.spi.cloud.types.PortabilityJob;
import org.datatransferproject.types.client.transfer.StartTransferJob;
import org.datatransferproject.types.client.transfer.TransferJob;

public class StartTransferJobAction
implements Action<StartTransferJob, TransferJob> {
    private final JobStore jobStore;
    private final Monitor monitor;

    @Inject
    StartTransferJobAction(JobStore jobStore, Monitor monitor) {
        this.jobStore = jobStore;
        this.monitor = monitor;
    }

    public Class<StartTransferJob> getRequestType() {
        return StartTransferJob.class;
    }

    public TransferJob handle(StartTransferJob startTransferJob) {
        String id = startTransferJob.getId();
        Preconditions.checkNotNull((Object)id, (Object)"transfer job ID required for StartTransferJobAction");
        UUID jobId = ActionUtils.decodeJobId(id);
        PortabilityJob job = this.jobStore.findJob(jobId);
        String authData = startTransferJob.getEncryptedAuthData();
        job = this.updateJobWithCredentials(jobId, job, authData);
        return new TransferJob(id, job.exportService(), job.importService(), job.transferDataType(), null, null, null, null, null, null);
    }

    private PortabilityJob updateJobWithCredentials(UUID jobId, PortabilityJob job, String authData) {
        JobAuthorization updatedJobAuthorization = job.jobAuthorization().toBuilder().setEncryptedAuthData(authData).setState(JobAuthorization.State.CREDS_STORED).build();
        job = job.toBuilder().setAndValidateJobAuthorization(updatedJobAuthorization).build();
        this.monitor.debug(() -> String.format("Updating job %s from CREDS_ENCRYPTION_KEY_GENERATED to CREDS_STORED", jobId), new Object[]{jobId});
        try {
            this.jobStore.updateJobWithCredentials(jobId, job);
            this.monitor.debug(() -> String.format("Updated job %s to CREDS_STORED", jobId), new Object[]{jobId, EventCode.API_JOB_CREDS_STORED});
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to update job", e);
        }
        return job;
    }
}

