/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.datatransferproject.spi.api.auth.AuthDataGenerator;
import org.datatransferproject.spi.api.auth.AuthServiceProviderRegistry;
import org.datatransferproject.spi.api.auth.extension.AuthServiceExtension;
import org.datatransferproject.types.common.models.DataVertical;

public class PortabilityAuthServiceProviderRegistry
implements AuthServiceProviderRegistry {
    private final ImmutableMap<String, AuthServiceExtension> authServiceProviderMap;
    private final ImmutableSet<DataVertical> supportedImportTypes;
    private final ImmutableSet<DataVertical> supportedExportTypes;

    @Inject
    public PortabilityAuthServiceProviderRegistry(Map<String, AuthServiceExtension> serviceProviderMap) {
        ImmutableMap.Builder serviceProviderBuilder = ImmutableMap.builder();
        ImmutableSet.Builder supportedImportTypesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder supportedExportTypesBuilder = ImmutableSet.builder();
        serviceProviderMap.forEach((service, provider) -> {
            List importTypes = provider.getImportTypes();
            List exportTypes = provider.getExportTypes();
            for (DataVertical type : importTypes) {
                Preconditions.checkArgument((boolean)exportTypes.contains(type), (String)"TransferDataType [%s] is available for import but not export in [%s] AuthServiceExtension", (Object)type, (Object)service);
                supportedImportTypesBuilder.add((Object)type);
            }
            supportedExportTypesBuilder.addAll((Iterable)exportTypes);
            serviceProviderBuilder.put(service, provider);
        });
        this.authServiceProviderMap = serviceProviderBuilder.build();
        this.supportedImportTypes = supportedImportTypesBuilder.build();
        this.supportedExportTypes = supportedExportTypesBuilder.build();
    }

    public AuthDataGenerator getAuthDataGenerator(String serviceId, DataVertical transferDataType, AuthServiceProviderRegistry.AuthMode mode) {
        AuthServiceExtension provider = (AuthServiceExtension)this.authServiceProviderMap.get((Object)serviceId);
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"AuthServiceExtension not found for serviceId [%s]", (Object)serviceId);
        switch (mode) {
            case EXPORT: {
                Preconditions.checkArgument((boolean)this.supportedExportTypes.contains((Object)transferDataType), (String)"AuthMode [%s] not valid for TransferDataType [%s]", (Object)mode, (Object)transferDataType);
                break;
            }
            case IMPORT: {
                Preconditions.checkArgument((boolean)this.supportedImportTypes.contains((Object)transferDataType), (String)"AuthMode [%s] not valid for TransferDataType [%s]", (Object)mode, (Object)transferDataType);
                break;
            }
            default: {
                throw new IllegalArgumentException("AuthMode [" + mode + "] not supported");
            }
        }
        return provider.getAuthDataGenerator(transferDataType, mode);
    }

    public Set<String> getImportServices(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.supportedImportTypes.contains((Object)transferDataType), (String)"TransferDataType [%s] is not valid for import", (Object)transferDataType);
        return this.authServiceProviderMap.values().stream().filter(sp -> sp.getImportTypes().stream().anyMatch(e -> e == transferDataType)).map(AuthServiceExtension::getServiceId).collect(Collectors.toSet());
    }

    public Set<String> getExportServices(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.supportedExportTypes.contains((Object)transferDataType), (String)"TransferDataType [%s] is not valid for export", (Object)transferDataType);
        return this.authServiceProviderMap.values().stream().filter(sp -> sp.getExportTypes().stream().anyMatch(e -> e == transferDataType)).map(AuthServiceExtension::getServiceId).collect(Collectors.toSet());
    }

    public Set<DataVertical> getTransferDataTypes() {
        return Sets.intersection(this.supportedExportTypes, this.supportedImportTypes);
    }
}

