/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api.token;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.inject.Inject;
import java.util.Date;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.api.token.TokenManager;

public class JWTTokenManager
implements TokenManager {
    public static final String JWT_KEY_NAME = "JWT_KEY";
    public static final String JWT_SECRET_NAME = "JWT_SECRET";
    private static final String ISSUER = "datatransferproject";
    private static final String ID_CLAIM_KEY = "portability-id";
    private static final int EXPIRATION_TIME_MILLIS = 60000;
    private final Algorithm algorithm;
    private final JWTVerifier verifier;
    private final Monitor monitor;

    @Inject
    public JWTTokenManager(String secret, Monitor monitor) {
        this.algorithm = JWTTokenManager.createAlgorithm(secret);
        this.verifier = JWTTokenManager.createVerifier(secret, ISSUER);
        this.monitor = monitor;
    }

    private static JWTVerifier createVerifier(String secret, String issuer) {
        return JWT.require((Algorithm)JWTTokenManager.createAlgorithm(secret)).withIssuer(new String[]{issuer}).build();
    }

    private static Algorithm createAlgorithm(String secret) {
        try {
            return Algorithm.HMAC256((String)secret);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Couldn't create Algorithm instance", e);
        }
    }

    public boolean verifyToken(String token) {
        try {
            this.verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException exception) {
            this.monitor.debug(() -> "Error verifying token", new Object[]{exception});
            return false;
        }
    }

    public UUID getJobIdFromToken(String token) {
        try {
            DecodedJWT jwt = this.verifier.verify(token);
            Claim claim = jwt.getClaim(ID_CLAIM_KEY);
            if (claim.isNull()) {
                return null;
            }
            return claim.isNull() ? null : UUID.fromString(claim.asString());
        }
        catch (JWTVerificationException exception) {
            this.monitor.debug(() -> "Error verifying token", new Object[]{exception});
            throw new RuntimeException("Error verifying token: " + token);
        }
    }

    public String createNewToken(UUID jobId) {
        try {
            return JWT.create().withIssuer(ISSUER).withClaim(ID_CLAIM_KEY, jobId.toString()).withExpiresAt(new Date(System.currentTimeMillis() + 60000L)).sign(this.algorithm);
        }
        catch (JWTCreationException e) {
            throw new RuntimeException("Error creating token for: " + jobId);
        }
    }
}

