/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.auth.rememberthemilk;

import com.fasterxml.jackson.xml.XmlMapper;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.auth.rememberthemilk.RememberTheMilkSignatureGenerator;
import org.datatransferproject.auth.rememberthemilk.model.AuthElement;
import org.datatransferproject.spi.api.auth.AuthDataGenerator;
import org.datatransferproject.spi.api.auth.AuthServiceProviderRegistry;
import org.datatransferproject.spi.api.types.AuthFlowConfiguration;
import org.datatransferproject.types.common.PortabilityCommon;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.AuthData;
import org.datatransferproject.types.transfer.auth.TokenAuthData;

public class RememberTheMilkAuthDataGenerator
implements AuthDataGenerator {
    private static final PortabilityCommon.AuthProtocol AUTH_PROTOCOL = PortabilityCommon.AuthProtocol.CUSTOM;
    private static final String AUTH_URL = "http://api.rememberthemilk.com/services/auth/";
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final String GET_TOKEN_URL = "https://api.rememberthemilk.com/services/rest/";
    private static final String GET_TOKEN_METHOD = "rtm.auth.getToken";
    private final RememberTheMilkSignatureGenerator signatureGenerator;
    private final String perms;
    private final Monitor monitor;
    private final XmlMapper xmlMapper;

    public RememberTheMilkAuthDataGenerator(AppCredentials appCredentials, AuthServiceProviderRegistry.AuthMode authMode, Monitor monitor) {
        this.signatureGenerator = new RememberTheMilkSignatureGenerator(appCredentials);
        this.perms = authMode == AuthServiceProviderRegistry.AuthMode.IMPORT ? "write" : "read";
        this.monitor = monitor;
        this.xmlMapper = new XmlMapper();
    }

    public AuthFlowConfiguration generateConfiguration(String callbackBaseUrl, String id) {
        URL authUrlSigned;
        try {
            authUrlSigned = this.signatureGenerator.getSignature(AUTH_URL, (Map<String, String>)ImmutableMap.of((Object)"perms", (Object)this.perms));
        }
        catch (Exception e) {
            this.monitor.severe(() -> "Error generating RememberTheMilk Authentication URL", new Object[]{e});
            return null;
        }
        return new AuthFlowConfiguration(authUrlSigned.toString(), this.getTokenUrl(), AUTH_PROTOCOL, null);
    }

    public AuthData generateAuthData(String callbackUrl, String authCode, String id, AuthData initialAuthData, String extra) {
        try {
            return new TokenAuthData(this.getToken(authCode));
        }
        catch (IOException e) {
            this.monitor.severe(() -> "Error getting RememberTheMilk AuthToken: ", new Object[]{e});
            return null;
        }
    }

    private String getToken(String frob) throws IOException {
        URL signedUrl = this.signatureGenerator.getSignature(GET_TOKEN_URL, (Map<String, String>)ImmutableMap.of((Object)"frob", (Object)frob, (Object)"method", (Object)GET_TOKEN_METHOD));
        HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory();
        HttpRequest getRequest = requestFactory.buildGetRequest(new GenericUrl(signedUrl));
        HttpResponse response = getRequest.execute();
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            throw new IOException("Bad status code: " + statusCode + " error: " + response.getStatusMessage());
        }
        AuthElement authElement = (AuthElement)this.xmlMapper.readValue(response.getContent(), AuthElement.class);
        Preconditions.checkState((boolean)authElement.stat.equals("ok"), (String)"state must be ok: %s", (Object)authElement);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)authElement.auth.token) ? 1 : 0) != 0, (String)"token must not be empty", (Object)authElement);
        return authElement.auth.token;
    }
}

