/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.auth.rememberthemilk;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.datatransferproject.types.transfer.auth.AppCredentials;

public final class RememberTheMilkSignatureGenerator {
    private final AppCredentials appCredentials;

    public RememberTheMilkSignatureGenerator(AppCredentials appCredentials) {
        this.appCredentials = (AppCredentials)Preconditions.checkNotNull((Object)appCredentials);
    }

    public URL getSignature(String base, Map<String, String> queryParams) {
        HashMap<String, String> modifiedParams = new HashMap<String, String>();
        modifiedParams.putAll(queryParams);
        modifiedParams.put("api_key", this.appCredentials.getKey());
        List orderedKeys = modifiedParams.keySet().stream().collect(Collectors.toList());
        Collections.sort(orderedKeys);
        ArrayList<String> queryParamStrings = new ArrayList<String>();
        StringBuilder resultBuilder = new StringBuilder();
        resultBuilder.append(this.appCredentials.getSecret());
        for (String key : orderedKeys) {
            String k = key.trim();
            String v = ((String)modifiedParams.get(key)).trim();
            resultBuilder.append(k).append(v);
            queryParamStrings.add(k + "=" + v);
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] thedigest = md.digest(resultBuilder.toString().getBytes(StandardCharsets.UTF_8));
            String signature = BaseEncoding.base16().encode(thedigest).toLowerCase();
            return new URL(base + "?" + String.join((CharSequence)"&", queryParamStrings) + "&api_sig=" + signature);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Couldn't find MD5 hash", e);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Couldn't parse authUrl", e);
        }
    }
}

