/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.bootstrap.vm;

import com.google.common.util.concurrent.UncaughtExceptionHandlers;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.datatransferproject.api.ApiMain;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.api.launcher.Version;
import org.datatransferproject.launcher.monitor.MonitorLoader;
import org.datatransferproject.transfer.WorkerMain;

public class SingleVMMain {
    private final Consumer<Exception> errorCallback;
    private final Monitor monitor = MonitorLoader.loadMonitor();
    private ExecutorService executorService;

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(UncaughtExceptionHandlers.systemExit());
        SingleVMMain singleVMMain = new SingleVMMain();
        Runtime.getRuntime().addShutdownHook(new Thread(singleVMMain::shutdown));
        singleVMMain.initializeWorkers(1);
        singleVMMain.initializeGateway();
    }

    public SingleVMMain() {
        this.errorCallback = e -> {
            this.monitor.severe(() -> "Exiting abnormally", new Object[]{e});
            this.monitor.flushLogs();
            System.exit(-1);
        };
    }

    public void initializeGateway() {
        String version = Version.getVersion();
        String hash = Version.getSourceHash();
        this.monitor.info(() -> String.format("Running version %s. Source repository hash %s", version, hash), new Object[0]);
        ApiMain apiMain = new ApiMain(this.monitor);
        try (InputStream stream = ApiMain.class.getClassLoader().getResourceAsStream("demo-selfsigned-keystore.jks");){
            if (stream == null) {
                throw new IllegalArgumentException("Demo keystore was not found");
            }
            char[] password = "password".toCharArray();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(stream, password);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, password);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(keyStore);
            apiMain.initializeHttps(trustManagerFactory, keyManagerFactory, keyStore);
            apiMain.start();
        }
        catch (Exception e) {
            this.errorCallback.accept(e);
        }
    }

    public void initializeWorkers(int workers) {
        if (workers < 1) {
            this.errorCallback.accept(new IllegalArgumentException("Invalid number of workers: " + workers));
            return;
        }
        this.executorService = Executors.newFixedThreadPool(workers);
        for (int i = 0; i < workers; ++i) {
            WorkerRunner workerRunner = new WorkerRunner();
            this.executorService.submit(workerRunner);
        }
    }

    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    private class WorkerRunner
    implements Runnable {
        private WorkerRunner() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        WorkerMain workerMain = new WorkerMain();
                        workerMain.initialize();
                        workerMain.poll();
                    }
                }
                catch (Exception e) {
                    SingleVMMain.this.errorCallback.accept(e);
                    continue;
                }
                break;
            }
        }
    }
}

