/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.backblaze;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.backblaze.common.BackblazeDataTransferClientFactory;
import org.datatransferproject.datatransfer.backblaze.photos.BackblazePhotosImporter;
import org.datatransferproject.datatransfer.backblaze.videos.BackblazeVideosImporter;
import org.datatransferproject.spi.cloud.connection.ConnectionProvider;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.models.DataVertical;

public class BackblazeTransferExtension
implements TransferExtension {
    public static final String SERVICE_ID = "Backblaze";
    private static final List<DataVertical> SUPPORTED_TYPES = ImmutableList.of((Object)DataVertical.PHOTOS, (Object)DataVertical.VIDEOS);
    private ImmutableMap<DataVertical, Importer> importerMap;
    private boolean initialized = false;

    public String getServiceId() {
        return SERVICE_ID;
    }

    public Exporter<?, ?> getExporter(DataVertical transferDataType) {
        throw new IllegalArgumentException();
    }

    public Importer<?, ?> getImporter(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized, (Object)"Trying to call getImporter before initalizing BackblazeTransferExtension");
        Preconditions.checkArgument((boolean)SUPPORTED_TYPES.contains(transferDataType), (Object)("Import of " + transferDataType + " not supported by Backblaze"));
        return (Importer)this.importerMap.get((Object)transferDataType);
    }

    public void initialize(ExtensionContext context) {
        Monitor monitor = context.getMonitor();
        monitor.debug(() -> "Starting Backblaze initialization", new Object[0]);
        if (this.initialized) {
            monitor.severe(() -> "BackblazeTransferExtension already initialized.", new Object[0]);
            return;
        }
        TemporaryPerJobDataStore jobStore = (TemporaryPerJobDataStore)context.getService(TemporaryPerJobDataStore.class);
        ImmutableMap.Builder importerBuilder = ImmutableMap.builder();
        BackblazeDataTransferClientFactory backblazeDataTransferClientFactory = new BackblazeDataTransferClientFactory(monitor);
        ConnectionProvider isProvider = new ConnectionProvider(jobStore);
        importerBuilder.put((Object)DataVertical.PHOTOS, (Object)new BackblazePhotosImporter(monitor, jobStore, isProvider, backblazeDataTransferClientFactory));
        importerBuilder.put((Object)DataVertical.VIDEOS, (Object)new BackblazeVideosImporter(monitor, jobStore, isProvider, backblazeDataTransferClientFactory));
        this.importerMap = importerBuilder.build();
        this.initialized = true;
    }
}

