/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.backblaze.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.backblaze.common.BackblazeDataTransferClient;
import org.datatransferproject.datatransfer.backblaze.common.BaseBackblazeS3ClientFactory;
import org.datatransferproject.datatransfer.backblaze.exception.BackblazeCredentialsException;
import org.datatransferproject.transfer.JobMetadata;
import org.datatransferproject.types.transfer.auth.TokenSecretAuthData;

public class BackblazeDataTransferClientFactory {
    private final Map<UUID, BackblazeDataTransferClient> backblazeDataTransferClientMap;
    private final Monitor monitor;
    private static final long SIZE_THRESHOLD_FOR_MULTIPART_UPLOAD = 0x1400000L;
    private static final long PART_SIZE_FOR_MULTIPART_UPLOAD = 0x500000L;

    public BackblazeDataTransferClientFactory(Monitor monitor) {
        this.monitor = monitor;
        this.backblazeDataTransferClientMap = new HashMap<UUID, BackblazeDataTransferClient>();
    }

    public BackblazeDataTransferClient getOrCreateB2Client(UUID jobId, TokenSecretAuthData authData) throws BackblazeCredentialsException, IOException {
        if (!this.backblazeDataTransferClientMap.containsKey(jobId)) {
            BackblazeDataTransferClient backblazeDataTransferClient = new BackblazeDataTransferClient(this.monitor, new BaseBackblazeS3ClientFactory(), 0x1400000L, 0x500000L);
            String exportService = JobMetadata.getExportService();
            backblazeDataTransferClient.init(authData.getToken(), authData.getSecret(), exportService);
            this.backblazeDataTransferClientMap.put(jobId, backblazeDataTransferClient);
        }
        return this.backblazeDataTransferClientMap.get(jobId);
    }
}

