/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.backblaze.common;

import java.net.URI;
import org.datatransferproject.datatransfer.backblaze.common.BackblazeS3ClientFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class BaseBackblazeS3ClientFactory
implements BackblazeS3ClientFactory {
    private static final String S3_ENDPOINT_FORMAT_STRING = "https://s3.%s.backblazeb2.com";

    @Override
    public S3Client createS3Client(String accessKey, String secretKey, String region) {
        AwsSessionCredentials awsCreds = AwsSessionCredentials.create((String)accessKey, (String)secretKey, (String)"");
        ClientOverrideConfiguration clientOverrideConfiguration = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().putHeader("User-Agent", "Facebook-DTP").build();
        Region awsRegion = Region.US_EAST_1;
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCreds))).overrideConfiguration(clientOverrideConfiguration)).endpointOverride(URI.create(String.format(S3_ENDPOINT_FORMAT_STRING, region)))).region(awsRegion)).build();
    }
}

