/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.backblaze.common;

import java.io.File;
import org.apache.http.impl.client.HttpClientBuilder;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.backblaze.common.BackblazeDataTransferClient;
import org.datatransferproject.datatransfer.backblaze.common.BaseBackblazeS3ClientFactory;
import org.datatransferproject.launcher.monitor.ConsoleMonitor;

public class BackblazeIntegrationTest {
    public static void main(String[] args) throws Exception {
        ConsoleMonitor monitor = new ConsoleMonitor(ConsoleMonitor.Level.DEBUG);
        BaseBackblazeS3ClientFactory factory = new BaseBackblazeS3ClientFactory();
        BackblazeDataTransferClient client = new BackblazeDataTransferClient((Monitor)monitor, factory, 0x1400000L, 0x500000L);
        String keyId = System.getenv("BACKBLAZE_KEY");
        String appKey = System.getenv("BACKBLAZE_SECRET");
        if (keyId == null || appKey == null) {
            System.err.println("Please set BACKBLAZE_KEY and BACKBLAZE_SECRET environment variables");
            return;
        }
        System.out.println("Initializing client with credentials...");
        client.init(keyId, appKey, "test-service", HttpClientBuilder.create().build());
        System.out.println("Client initialized successfully!");
        File testFile = new File("/Users/anthony.ross/Desktop/test.txt");
        System.out.println("Uploading file: " + testFile.getAbsolutePath());
        String versionId = client.uploadFile("test-upload-" + System.currentTimeMillis(), testFile);
        System.out.println("Upload successful! Version ID: " + versionId);
    }
}

