/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.backblaze.photos;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.backblaze.common.BackblazeDataTransferClient;
import org.datatransferproject.datatransfer.backblaze.common.BackblazeDataTransferClientFactory;
import org.datatransferproject.spi.cloud.connection.ConnectionProvider;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.idempotentexecutor.ItemImportResult;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.DownloadableItem;
import org.datatransferproject.types.common.ImportableItem;
import org.datatransferproject.types.common.models.photos.PhotoAlbum;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.photos.PhotosContainerResource;
import org.datatransferproject.types.transfer.auth.TokenSecretAuthData;

public class BackblazePhotosImporter
implements Importer<TokenSecretAuthData, PhotosContainerResource> {
    private static final String PHOTO_TRANSFER_MAIN_FOLDER = "Photo Transfer";
    private final TemporaryPerJobDataStore jobStore;
    private final ConnectionProvider connectionProvider;
    private final Monitor monitor;
    private final BackblazeDataTransferClientFactory b2ClientFactory;

    public BackblazePhotosImporter(Monitor monitor, TemporaryPerJobDataStore jobStore, ConnectionProvider connectionProvider, BackblazeDataTransferClientFactory b2ClientFactory) {
        this.monitor = monitor;
        this.jobStore = jobStore;
        this.connectionProvider = connectionProvider;
        this.b2ClientFactory = b2ClientFactory;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentExecutor, TokenSecretAuthData authData, PhotosContainerResource data) throws Exception {
        if (data == null) {
            return ImportResult.OK;
        }
        BackblazeDataTransferClient b2Client = this.b2ClientFactory.getOrCreateB2Client(jobId, authData);
        if (data.getAlbums() != null && data.getAlbums().size() > 0) {
            for (PhotoAlbum album : data.getAlbums()) {
                idempotentExecutor.executeAndSwallowIOExceptions(album.getId(), String.format("Caching album name for album '%s'", album.getId()), () -> album.getName());
            }
        }
        LongAdder totalImportedFilesSizes = new LongAdder();
        if (data.getPhotos() != null && data.getPhotos().size() > 0) {
            for (PhotoModel photo : data.getPhotos()) {
                idempotentExecutor.importAndSwallowIOExceptions((ImportableItem)photo, p -> {
                    ItemImportResult<String> fileImportResult = this.importSinglePhoto(idempotentExecutor, b2Client, jobId, (PhotoModel)p);
                    if (fileImportResult.hasBytes()) {
                        totalImportedFilesSizes.add(fileImportResult.getBytes());
                    }
                    return fileImportResult;
                });
            }
        }
        return ImportResult.OK.copyWithBytes(Long.valueOf(totalImportedFilesSizes.longValue()));
    }

    private ItemImportResult<String> importSinglePhoto(IdempotentImportExecutor idempotentExecutor, BackblazeDataTransferClient b2Client, UUID jobId, PhotoModel photo) throws IOException {
        File file;
        String albumName = (String)((Object)idempotentExecutor.getCachedValue(photo.getAlbumId()));
        try (InputStream is = this.connectionProvider.getInputStreamForItem(jobId, (DownloadableItem)photo).getStream();){
            file = this.jobStore.getTempFileFromInputStream(is, photo.getDataId(), ".jpg");
        }
        String response = b2Client.uploadFile(String.format("%s/%s/%s.jpg", PHOTO_TRANSFER_MAIN_FOLDER, albumName, photo.getDataId()), file);
        long size = file.length();
        try {
            if (photo.isInTempStore()) {
                this.jobStore.removeData(jobId, photo.getFetchableUrl());
            }
        }
        catch (Exception e) {
            this.monitor.info(() -> String.format("Exception swallowed while removing data for jobId %s, localPath %s", jobId, photo.getFetchableUrl()), new Object[]{e});
        }
        return ItemImportResult.success((Serializable)((Object)response), (Long)size);
    }
}

