/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.daybook;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import okhttp3.OkHttpClient;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.transfer.JobMetadata;
import org.datatransferproject.transfer.daybook.photos.DaybookPhotosImporter;
import org.datatransferproject.transfer.daybook.social.DaybookPostsImporter;
import org.datatransferproject.types.common.models.DataVertical;

public class DaybookTransferExtension
implements TransferExtension {
    private static final String SERVICE_ID = "Daybook";
    private static final String BASE_URL = "https://us-central1-diary-a77f6.cloudfunctions.net/post-daybook-dtp";
    private static final ImmutableList<DataVertical> SUPPORTED_DATA_TYPES = ImmutableList.of((Object)DataVertical.PHOTOS, (Object)DataVertical.SOCIAL_POSTS);
    private boolean initialized = false;
    private ImmutableMap<DataVertical, Importer<?, ?>> importerMap;

    public void initialize(ExtensionContext context) {
        Monitor monitor = context.getMonitor();
        if (this.initialized) {
            monitor.severe(() -> "DaybookTransferExtension is already initialized", new Object[0]);
            return;
        }
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OkHttpClient client = (OkHttpClient)context.getService(OkHttpClient.class);
        TemporaryPerJobDataStore jobStore = (TemporaryPerJobDataStore)context.getService(TemporaryPerJobDataStore.class);
        ImmutableMap.Builder importerBuilder = ImmutableMap.builder();
        String exportService = JobMetadata.getExportService();
        importerBuilder.put((Object)DataVertical.PHOTOS, (Object)new DaybookPhotosImporter(monitor, client, jobStore, BASE_URL, exportService));
        importerBuilder.put((Object)DataVertical.SOCIAL_POSTS, (Object)new DaybookPostsImporter(monitor, client, mapper, BASE_URL, exportService));
        this.importerMap = importerBuilder.build();
        this.initialized = true;
    }

    public String getServiceId() {
        return SERVICE_ID;
    }

    public Importer<?, ?> getImporter(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized, (Object)"DaybookTransferExtension is not initialized. Unable to get Importer");
        Preconditions.checkArgument((boolean)SUPPORTED_DATA_TYPES.contains((Object)transferDataType), (Object)("DaybookTransferExtension doesn't support " + transferDataType));
        return (Importer)this.importerMap.get((Object)transferDataType);
    }

    public Exporter<?, ?> getExporter(DataVertical transferDataType) {
        throw new IllegalArgumentException();
    }
}

