/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.daybook.photos;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.idempotentexecutor.ItemImportResult;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.ImportableItem;
import org.datatransferproject.types.common.models.photos.PhotoAlbum;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.photos.PhotosContainerResource;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class DaybookPhotosImporter
implements Importer<TokensAndUrlAuthData, PhotosContainerResource> {
    private final OkHttpClient client;
    private final TemporaryPerJobDataStore jobStore;
    private final Monitor monitor;
    private final String baseUrl;
    private final String exportService;

    public DaybookPhotosImporter(Monitor monitor, OkHttpClient client, TemporaryPerJobDataStore jobStore, String baseUrl, String exportService) {
        this.client = client;
        this.jobStore = jobStore;
        this.monitor = monitor;
        this.baseUrl = baseUrl;
        this.exportService = exportService;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor executor, TokensAndUrlAuthData authData, PhotosContainerResource resource) throws Exception {
        if (resource == null) {
            return ImportResult.OK;
        }
        this.monitor.debug(() -> String.format("Number of Photos: %d", resource.getPhotos().size()), new Object[0]);
        for (PhotoAlbum album : resource.getAlbums()) {
            executor.executeAndSwallowIOExceptions(album.getId(), album.getName(), () -> this.importAlbum(album));
        }
        for (PhotoModel photo : resource.getPhotos()) {
            executor.importAndSwallowIOExceptions((ImportableItem)photo, photoModel -> {
                String albumId = Strings.isNullOrEmpty((String)photo.getAlbumId()) ? null : (String)((Object)executor.getCachedValue(photo.getAlbumId()));
                return this.importPhoto(photo, jobId, authData, albumId);
            });
        }
        return new ImportResult(ImportResult.ResultType.OK);
    }

    private String importAlbum(PhotoAlbum album) {
        String description = album.getDescription();
        String album_name = album.getName();
        this.monitor.debug(() -> String.format("Album Name: %s", album_name), new Object[0]);
        if (!Strings.isNullOrEmpty((String)description)) {
            this.monitor.debug(() -> String.format("Album description: %s", description), new Object[0]);
        }
        return album_name;
    }

    private ItemImportResult<Integer> importPhoto(PhotoModel photoModel, UUID jobId, TokensAndUrlAuthData authData, String newAlbumId) throws IOException {
        InputStream inputStream;
        String imageDescription = photoModel.getDescription();
        String title = photoModel.getTitle();
        if (photoModel.isInTempStore()) {
            inputStream = this.jobStore.getStream(jobId, photoModel.getFetchableUrl()).getStream();
        } else if (photoModel.getFetchableUrl() != null) {
            inputStream = new URL(photoModel.getFetchableUrl()).openStream();
        } else {
            String errorMessage = "Can't get inputStream for a photo";
            this.monitor.severe(() -> errorMessage, new Object[0]);
            return ItemImportResult.error((Exception)new IOException(errorMessage), null);
        }
        byte[] imageBytes = ByteStreams.toByteArray((InputStream)inputStream);
        String imageData = Base64.getEncoder().encodeToString(imageBytes);
        Request.Builder requestBuilder = new Request.Builder().url(this.baseUrl);
        requestBuilder.header("token", authData.getAccessToken());
        FormBody.Builder builder = new FormBody.Builder().add("image", imageData).add("exporter", this.exportService);
        if (!Strings.isNullOrEmpty((String)newAlbumId)) {
            builder.add("album", newAlbumId);
        }
        if (!Strings.isNullOrEmpty((String)title)) {
            builder.add("title", title);
        }
        if (!Strings.isNullOrEmpty((String)imageDescription)) {
            builder.add("description", imageDescription);
        }
        FormBody formBody = builder.build();
        requestBuilder.post((RequestBody)formBody);
        try (Response response = this.client.newCall(requestBuilder.build()).execute();){
            int code = response.code();
            Preconditions.checkArgument((code >= 200 && code <= 299 ? 1 : 0) != 0, (Object)String.format("Error occurred in request for %s, code: %s, message: %s", this.baseUrl, code, response.message()));
            if (photoModel.isInTempStore()) {
                this.jobStore.removeData(jobId, photoModel.getFetchableUrl());
            }
            ItemImportResult itemImportResult = ItemImportResult.success((Serializable)Integer.valueOf(response.code()), (Long)Long.valueOf(imageBytes.length));
            return itemImportResult;
        }
    }
}

