/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.daybook.social;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.idempotentexecutor.ItemImportResult;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.ImportableItem;
import org.datatransferproject.types.common.models.social.SocialActivityAttachment;
import org.datatransferproject.types.common.models.social.SocialActivityAttachmentType;
import org.datatransferproject.types.common.models.social.SocialActivityContainerResource;
import org.datatransferproject.types.common.models.social.SocialActivityModel;
import org.datatransferproject.types.common.models.social.SocialActivityType;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class DaybookPostsImporter
implements Importer<TokensAndUrlAuthData, SocialActivityContainerResource> {
    private final Monitor monitor;
    private final ObjectMapper objectMapper;
    private final OkHttpClient client;
    private final String baseUrl;
    private final String exportService;

    public DaybookPostsImporter(Monitor monitor, OkHttpClient client, ObjectMapper objectMapper, String baseUrl, String exportService) {
        this.baseUrl = baseUrl;
        this.client = client;
        this.monitor = monitor;
        this.objectMapper = objectMapper;
        this.exportService = exportService;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor executor, TokensAndUrlAuthData authData, SocialActivityContainerResource resource) throws Exception {
        if (resource == null) {
            return ImportResult.OK;
        }
        this.monitor.debug(() -> String.format("Number of Posts: %d", resource.getCounts().get("activitiesCount")), new Object[0]);
        LongAdder totalImportedFilesSizes = new LongAdder();
        for (SocialActivityModel activity : resource.getActivities()) {
            if (activity.getType() != SocialActivityType.NOTE && activity.getType() != SocialActivityType.POST) continue;
            executor.importAndSwallowIOExceptions((ImportableItem)activity, currentActivity -> {
                ItemImportResult<String> insertActivityResult = this.insertActivity(activity, authData);
                if (insertActivityResult != null && insertActivityResult.hasBytes()) {
                    totalImportedFilesSizes.add(insertActivityResult.getBytes());
                }
                return insertActivityResult;
            });
        }
        return ImportResult.OK.copyWithBytes(Long.valueOf(totalImportedFilesSizes.longValue()));
    }

    private ItemImportResult<String> insertActivity(SocialActivityModel activity, TokensAndUrlAuthData authData) throws IOException {
        String json;
        HashMap<String, String> imageMap = new HashMap<String, String>();
        HashMap<String, String> linkMap = new HashMap<String, String>();
        Long size = null;
        String content = activity.getContent() == null ? "" : activity.getContent();
        String title = activity.getTitle() == null ? "" : activity.getTitle();
        String location = activity.getLocation() == null || activity.getLocation().getName() == null ? "" : activity.getLocation().getName();
        String published = activity.getPublished().toString();
        Request.Builder requestBuilder = new Request.Builder().url(this.baseUrl);
        requestBuilder.header("token", authData.getAccessToken());
        FormBody.Builder builder = new FormBody.Builder().add("type", "POSTS").add("exporter", this.exportService).add("content", content).add("title", title).add("location", location).add("published", published);
        Collection linkAttachments = activity.getAttachments().stream().filter(attachment -> attachment.getType() == SocialActivityAttachmentType.LINK).collect(Collectors.toList());
        Collection imageAttachments = activity.getAttachments().stream().filter(attachment -> attachment.getType() == SocialActivityAttachmentType.IMAGE).collect(Collectors.toList());
        if (!linkAttachments.isEmpty()) {
            for (SocialActivityAttachment attachment2 : linkAttachments) {
                linkMap.put(attachment2.getName(), attachment2.getUrl());
            }
            try {
                json = this.objectMapper.writeValueAsString(linkMap);
                builder.add("link", json);
            }
            catch (JsonProcessingException e) {
                this.monitor.info(() -> String.format("Error processing JSON: %s", e.getMessage()), new Object[0]);
            }
        }
        if (!imageAttachments.isEmpty()) {
            for (SocialActivityAttachment image : imageAttachments) {
                imageMap.put(image.getName() != null ? image.getName() : image.getUrl(), image.getUrl());
            }
            try {
                json = this.objectMapper.writeValueAsString(imageMap);
                builder.add("image", json);
            }
            catch (JsonProcessingException e) {
                this.monitor.info(() -> String.format("Error processing JSON: %s", e.getMessage()), new Object[0]);
            }
        }
        FormBody formBody = builder.build();
        requestBuilder.post((RequestBody)formBody);
        size = formBody.contentLength();
        try (Response response = this.client.newCall(requestBuilder.build()).execute();){
            int code = response.code();
            if (code < 200 || code > 299) {
                throw new IOException(String.format("Error occurred in request for adding entry, message: %s", response.message()));
            }
            ItemImportResult itemImportResult = ItemImportResult.success((Serializable)((Object)response.message()), (Long)size);
            return itemImportResult;
        }
    }
}

