/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.deezer;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import org.datatransferproject.transfer.deezer.model.Error;
import org.datatransferproject.transfer.deezer.model.InsertResponse;
import org.datatransferproject.transfer.deezer.model.PlaylistDetails;
import org.datatransferproject.transfer.deezer.model.PlaylistSummary;
import org.datatransferproject.transfer.deezer.model.PlaylistsResponse;
import org.datatransferproject.transfer.deezer.model.Track;
import org.datatransferproject.transfer.deezer.model.User;
import org.datatransferproject.types.transfer.serviceconfig.TransferServiceConfig;

public class DeezerApi {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String BASE_URL = "https://api.deezer.com";
    private final String accessToken;
    private final HttpTransport httpTransport;
    private final RateLimiter perUserRateLimiter;

    public DeezerApi(String accessToken, HttpTransport httpTransport, TransferServiceConfig transferServiceConfig) {
        this.accessToken = accessToken;
        this.httpTransport = httpTransport;
        this.perUserRateLimiter = transferServiceConfig.getPerUserRateLimiter();
    }

    public User getUser() throws IOException {
        return this.makeRequest("https://api.deezer.com/user/me", User.class);
    }

    public Collection<PlaylistSummary> getPlaylists() throws IOException {
        return ImmutableList.copyOf((Object[])this.makeRequest("https://api.deezer.com/user/me/playlists", PlaylistsResponse.class).getData());
    }

    public PlaylistDetails getPlaylistDetails(long playlistId) throws IOException {
        return this.makeRequest("https://api.deezer.com/playlist/" + playlistId, PlaylistDetails.class);
    }

    public Track getTrack(long trackId) throws IOException {
        return this.makeRequest("https://api.deezer.com/track/" + trackId, Track.class);
    }

    public InsertResponse createPlaylist(String title) throws IOException {
        String result = this.makePostRequest("https://api.deezer.com/user/me/playlists", (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title));
        return (InsertResponse)MAPPER.readValue(result, InsertResponse.class);
    }

    public Error insertTracksInPlaylist(long playlist, Collection<Long> tracks) throws IOException {
        if (tracks.isEmpty()) {
            return null;
        }
        String result = this.makePostRequest("https://api.deezer.com/playlist/" + playlist + "/tracks", (Map<String, String>)ImmutableMap.of((Object)"songs", (Object)Joiner.on((String)",").join(tracks)));
        if ("true".equalsIgnoreCase(result)) {
            return null;
        }
        return (Error)MAPPER.readValue(result, Error.class);
    }

    public Track lookupTrackByIsrc(String isrc) throws IOException {
        return this.makeRequest("https://api.deezer.com/2.0/track/isrc:" + isrc, Track.class);
    }

    private String makePostRequest(String url, Map<String, String> params) throws IOException {
        HttpRequestFactory requestFactory = this.httpTransport.createRequestFactory();
        StringBuilder extraArgs = new StringBuilder();
        params.entrySet().forEach(entry -> {
            try {
                extraArgs.append("&").append((String)entry.getKey()).append("=").append(URLEncoder.encode((String)entry.getValue(), "UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        });
        HttpRequest getRequest = requestFactory.buildGetRequest(new GenericUrl(url + "?output=json&request_method=post&access_token=" + this.accessToken + extraArgs));
        this.perUserRateLimiter.acquire();
        HttpResponse response = getRequest.execute();
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            throw new IOException("Bad status code: " + statusCode + " error: " + response.getStatusMessage());
        }
        String result = CharStreams.toString((Readable)new InputStreamReader(response.getContent(), Charsets.UTF_8));
        return result;
    }

    private <T> T makeRequest(String url, Class<T> clazz) throws IOException {
        HttpRequestFactory requestFactory = this.httpTransport.createRequestFactory();
        HttpRequest getRequest = requestFactory.buildGetRequest(new GenericUrl(url + "?output=json&access_token=" + this.accessToken));
        this.perUserRateLimiter.acquire();
        HttpResponse response = getRequest.execute();
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            throw new IOException("Bad status code: " + statusCode + " error: " + response.getStatusMessage());
        }
        String result = CharStreams.toString((Readable)new InputStreamReader(response.getContent(), Charsets.UTF_8));
        return (T)MAPPER.readValue(result, clazz);
    }
}

