/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.facebook.photos;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.restfb.Connection;
import com.restfb.types.Album;
import com.restfb.types.Photo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.transfer.facebook.photos.FacebookPhotosInterface;
import org.datatransferproject.transfer.facebook.photos.RestFbFacebookPhotos;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.IdOnlyContainerResource;
import org.datatransferproject.types.common.models.photos.PhotoAlbum;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.photos.PhotosContainerResource;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class FacebookPhotosExporter
implements Exporter<TokensAndUrlAuthData, PhotosContainerResource> {
    private static final String ALBUM_TOKEN_PREFIX = "album:";
    static final String PHOTO_TOKEN_PREFIX = "media:";
    private AppCredentials appCredentials;
    private FacebookPhotosInterface photosInterface;

    public FacebookPhotosExporter(AppCredentials appCredentials) {
        this.appCredentials = appCredentials;
    }

    @VisibleForTesting
    FacebookPhotosExporter(AppCredentials appCredentials, FacebookPhotosInterface photosInterface) {
        this.appCredentials = appCredentials;
        this.photosInterface = photosInterface;
    }

    public ExportResult<PhotosContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) {
        boolean paginationDataPresent;
        Preconditions.checkNotNull((Object)authData);
        if (!exportInformation.isPresent()) {
            return this.exportAlbums(authData, Optional.empty());
        }
        StringPaginationToken paginationToken = (StringPaginationToken)exportInformation.get().getPaginationData();
        ContainerResource containerResource = exportInformation.get().getContainerResource();
        boolean containerResourcePresent = containerResource != null;
        boolean bl = paginationDataPresent = paginationToken != null;
        if (!containerResourcePresent && paginationDataPresent && paginationToken.getToken().startsWith(ALBUM_TOKEN_PREFIX)) {
            return this.exportAlbums(authData, Optional.of(paginationToken));
        }
        if (containerResourcePresent && containerResource instanceof PhotosContainerResource) {
            PhotosContainerResource photosContainerResource = (PhotosContainerResource)containerResource;
            Preconditions.checkNotNull((Object)photosContainerResource.getAlbums());
            ContinuationData continuationData = new ContinuationData(null);
            for (PhotoAlbum album : photosContainerResource.getAlbums()) {
                continuationData.addContainerResource((ContainerResource)new IdOnlyContainerResource(album.getId()));
            }
            return new ExportResult(ExportResult.ResultType.CONTINUE, (DataModel)photosContainerResource, continuationData);
        }
        if (containerResourcePresent && containerResource instanceof IdOnlyContainerResource) {
            return this.exportPhotos(authData, (IdOnlyContainerResource)containerResource, Optional.ofNullable(paginationToken));
        }
        throw new IllegalStateException(String.format("Invalid state passed into FacebookPhotosExporter. ExportInformation: %s", exportInformation));
    }

    private ExportResult<PhotosContainerResource> exportAlbums(TokensAndUrlAuthData authData, Optional<StringPaginationToken> paginationData) {
        Optional<String> paginationToken = this.stripTokenPrefix(paginationData, ALBUM_TOKEN_PREFIX);
        ArrayList<PhotoAlbum> exportAlbums = new ArrayList<PhotoAlbum>();
        Connection<Album> connection = this.getOrCreatePhotosInterface(authData).getAlbums(paginationToken);
        StringPaginationToken nextPageData = null;
        String token = connection.getAfterCursor();
        if (!Strings.isNullOrEmpty((String)token)) {
            nextPageData = new StringPaginationToken(ALBUM_TOKEN_PREFIX + token);
        }
        ContinuationData continuationData = new ContinuationData(nextPageData);
        List albums = connection.getData();
        for (Album album : albums) {
            exportAlbums.add(new PhotoAlbum(album.getId(), album.getName(), album.getDescription()));
            continuationData.addContainerResource((ContainerResource)new IdOnlyContainerResource(album.getId()));
        }
        return new ExportResult(ExportResult.ResultType.CONTINUE, (DataModel)new PhotosContainerResource(exportAlbums, null), continuationData);
    }

    private ExportResult<PhotosContainerResource> exportPhotos(TokensAndUrlAuthData authData, IdOnlyContainerResource containerResource, Optional<StringPaginationToken> paginationData) {
        Optional<String> paginationToken = this.stripTokenPrefix(paginationData, PHOTO_TOKEN_PREFIX);
        ArrayList<PhotoModel> exportPhotos = new ArrayList<PhotoModel>();
        String albumId = containerResource.getId();
        Connection<Photo> photoConnection = this.getOrCreatePhotosInterface(authData).getPhotos(albumId, paginationToken);
        List photos = photoConnection.getData();
        for (Photo photo : photos) {
            Preconditions.checkNotNull((Object)((Photo.Image)photo.getImages().get(0)).getSource());
            exportPhotos.add(new PhotoModel(String.format("%s.jpg", photo.getId()), ((Photo.Image)photo.getImages().get(0)).getSource(), photo.getName(), "image/jpg", photo.getId(), albumId, false));
        }
        String token = photoConnection.getAfterCursor();
        if (Strings.isNullOrEmpty((String)token)) {
            return new ExportResult(ExportResult.ResultType.END, (DataModel)new PhotosContainerResource(null, exportPhotos));
        }
        StringPaginationToken nextPageData = new StringPaginationToken(PHOTO_TOKEN_PREFIX + token);
        ContinuationData continuationData = new ContinuationData((PaginationData)nextPageData);
        continuationData.addContainerResource((ContainerResource)containerResource);
        return new ExportResult(ExportResult.ResultType.CONTINUE, (DataModel)new PhotosContainerResource(null, exportPhotos), continuationData);
    }

    private Optional<String> stripTokenPrefix(Optional<StringPaginationToken> paginationData, String prefix) {
        Optional<String> paginationToken = Optional.empty();
        if (paginationData.isPresent()) {
            String token = paginationData.get().getToken();
            Preconditions.checkArgument((boolean)token.startsWith(prefix), (Object)("Invalid pagination token " + token));
            paginationToken = Optional.of(token.substring(prefix.length()));
        }
        return paginationToken;
    }

    private synchronized FacebookPhotosInterface getOrCreatePhotosInterface(TokensAndUrlAuthData authData) {
        return this.photosInterface == null ? this.makePhotosInterface(authData) : this.photosInterface;
    }

    private synchronized FacebookPhotosInterface makePhotosInterface(TokensAndUrlAuthData authData) {
        this.photosInterface = new RestFbFacebookPhotos(authData, this.appCredentials);
        return this.photosInterface;
    }
}

