/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.facebook.photos;

import com.restfb.Connection;
import com.restfb.DefaultFacebookClient;
import com.restfb.Parameter;
import com.restfb.Version;
import com.restfb.types.Album;
import com.restfb.types.Photo;
import java.util.ArrayList;
import java.util.Optional;
import org.datatransferproject.transfer.facebook.photos.FacebookPhotosInterface;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class RestFbFacebookPhotos
implements FacebookPhotosInterface {
    private DefaultFacebookClient client;

    RestFbFacebookPhotos(TokensAndUrlAuthData authData, AppCredentials appCredentials) {
        this.client = new DefaultFacebookClient(authData.getAccessToken(), appCredentials.getSecret(), Version.VERSION_3_0);
    }

    @Override
    public Connection<Album> getAlbums(Optional<String> paginationToken) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(Parameter.with((String)"fields", (Object)"description,name"));
        paginationToken.ifPresent(token -> parameters.add(Parameter.with((String)"after", (Object)token)));
        return this.client.fetchConnection("me/albums", Album.class, parameters.toArray(new Parameter[0]));
    }

    @Override
    public Connection<Photo> getPhotos(String albumId, Optional<String> paginationToken) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(Parameter.with((String)"fields", (Object)"name,images"));
        paginationToken.ifPresent(token -> parameters.add(Parameter.with((String)"after", (Object)token)));
        return this.client.fetchConnection(String.format("%s/photos", albumId), Photo.class, parameters.toArray(new Parameter[0]));
    }
}

