/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.facebook.videos;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.restfb.Connection;
import com.restfb.exception.FacebookGraphException;
import com.restfb.types.Video;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.spi.transfer.types.CopyExceptionWithFailureReason;
import org.datatransferproject.transfer.facebook.videos.FacebookVideosInterface;
import org.datatransferproject.transfer.facebook.videos.RestFbFacebookVideos;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.videos.VideoObject;
import org.datatransferproject.types.common.models.videos.VideosContainerResource;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class FacebookVideosExporter
implements Exporter<TokensAndUrlAuthData, VideosContainerResource> {
    private final Monitor monitor;
    private AppCredentials appCredentials;
    private FacebookVideosInterface videosInterface;

    public FacebookVideosExporter(AppCredentials appCredentials, Monitor monitor) {
        this.appCredentials = appCredentials;
        this.monitor = monitor;
    }

    @VisibleForTesting
    FacebookVideosExporter(AppCredentials appCredentials, FacebookVideosInterface videosInterface, Monitor monitor) {
        this.appCredentials = appCredentials;
        this.videosInterface = videosInterface;
        this.monitor = monitor;
    }

    public ExportResult<VideosContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) throws CopyExceptionWithFailureReason {
        Preconditions.checkNotNull((Object)authData);
        return this.exportVideos(authData, exportInformation.map(e -> (StringPaginationToken)e.getPaginationData()));
    }

    private ExportResult<VideosContainerResource> exportVideos(TokensAndUrlAuthData authData, Optional<StringPaginationToken> paginationData) throws CopyExceptionWithFailureReason {
        Optional<String> paginationToken = paginationData.map(StringPaginationToken::getToken);
        try {
            Connection<Video> videoConnection = this.getOrCreateVideosInterface(authData).getVideos(paginationToken);
            List videos = videoConnection.getData();
            if (videos.isEmpty()) {
                return new ExportResult(ExportResult.ResultType.END, null);
            }
            ArrayList<VideoObject> exportVideos = new ArrayList<VideoObject>();
            for (Video video : videos) {
                String url = video.getSource();
                String fbid = video.getId();
                if (null == url || url.isEmpty()) {
                    this.monitor.severe(() -> String.format("Source was missing or empty for video %s", fbid), new Object[0]);
                    continue;
                }
                exportVideos.add(new VideoObject(String.format("%s.mp4", fbid), url, video.getDescription(), "video/mp4", fbid, null, false));
            }
            String token = videoConnection.getAfterCursor();
            if (Strings.isNullOrEmpty((String)token)) {
                return new ExportResult(ExportResult.ResultType.END, (DataModel)new VideosContainerResource(null, exportVideos));
            }
            StringPaginationToken nextPageData = new StringPaginationToken(token);
            ContinuationData continuationData = new ContinuationData((PaginationData)nextPageData);
            return new ExportResult(ExportResult.ResultType.CONTINUE, (DataModel)new VideosContainerResource(null, exportVideos), continuationData);
        }
        catch (FacebookGraphException e) {
            String message = e.getMessage();
            if (message != null && message.contains("code 100, subcode 33")) {
                this.monitor.info(() -> "Cannot find videos to export, skipping to the next bunch", new Object[]{e});
                return new ExportResult(ExportResult.ResultType.END, null);
            }
            throw e;
        }
    }

    private synchronized FacebookVideosInterface getOrCreateVideosInterface(TokensAndUrlAuthData authData) {
        return this.videosInterface == null ? this.makeVideosInterface(authData) : this.videosInterface;
    }

    private synchronized FacebookVideosInterface makeVideosInterface(TokensAndUrlAuthData authData) {
        this.videosInterface = new RestFbFacebookVideos(authData, this.appCredentials);
        return this.videosInterface;
    }
}

