/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.facebook.videos;

import com.restfb.DefaultFacebookClient;
import com.restfb.FacebookClient;
import com.restfb.Parameter;
import com.restfb.Version;
import com.restfb.types.GraphResponse;
import java.util.ArrayList;
import java.util.UUID;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.models.videos.VideoObject;
import org.datatransferproject.types.common.models.videos.VideosContainerResource;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class FacebookVideosImporter
implements Importer<TokensAndUrlAuthData, VideosContainerResource> {
    private AppCredentials appCredentials;

    public FacebookVideosImporter(AppCredentials appCredentials) {
        this.appCredentials = appCredentials;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor executor, TokensAndUrlAuthData authData, VideosContainerResource data) {
        DefaultFacebookClient client = new DefaultFacebookClient(authData.getAccessToken(), this.appCredentials.getSecret(), Version.VERSION_3_0);
        for (VideoObject video : data.getVideos()) {
            this.importSingleVideo((FacebookClient)client, video);
        }
        return ImportResult.OK;
    }

    void importSingleVideo(FacebookClient client, VideoObject video) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(Parameter.with((String)"file_url", (Object)video.getContentUrl().toString()));
        if (video.getDescription() != null) {
            params.add(Parameter.with((String)"description", (Object)video.getDescription()));
        }
        String endpoint = "me/videos";
        client.publish(endpoint, GraphResponse.class, params.toArray(new Parameter[0]));
    }
}

