/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.facebook;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.transfer.facebook.photos.FacebookPhotosExporter;
import org.datatransferproject.transfer.facebook.videos.FacebookVideosExporter;
import org.datatransferproject.transfer.facebook.videos.FacebookVideosImporter;
import org.datatransferproject.types.transfer.auth.AppCredentials;

public class FacebookTransferExtension
implements TransferExtension {
    private static final String SERVICE_ID = "Facebook";
    private boolean initialized = false;
    private static final ImmutableList<String> SUPPORTED_SERVICES = ImmutableList.of((Object)"PHOTOS", (Object)"VIDEOS");
    private ImmutableMap<String, Importer> importerMap;
    private ImmutableMap<String, Exporter> exporterMap;

    public String getServiceId() {
        return SERVICE_ID;
    }

    public Exporter<?, ?> getExporter(String transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized);
        Preconditions.checkArgument((boolean)SUPPORTED_SERVICES.contains((Object)transferDataType));
        return (Exporter)this.exporterMap.get((Object)transferDataType);
    }

    public Importer<?, ?> getImporter(String transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized);
        Preconditions.checkArgument((boolean)SUPPORTED_SERVICES.contains((Object)transferDataType));
        return (Importer)this.importerMap.get((Object)transferDataType);
    }

    public void initialize(ExtensionContext context) {
        AppCredentials appCredentials;
        if (this.initialized) {
            return;
        }
        Monitor monitor = context.getMonitor();
        try {
            appCredentials = ((AppCredentialStore)context.getService(AppCredentialStore.class)).getAppCredentials("FACEBOOK_KEY", "FACEBOOK_SECRET");
        }
        catch (IOException e) {
            monitor.info(() -> "Unable to retrieve Facebook AppCredentials. Did you set FACEBOOK_KEY and FACEBOOK_SECRET?", new Object[]{e});
            return;
        }
        ImmutableMap.Builder importerBuilder = ImmutableMap.builder();
        importerBuilder.put((Object)"VIDEOS", (Object)new FacebookVideosImporter(appCredentials));
        this.importerMap = importerBuilder.build();
        ImmutableMap.Builder exporterBuilder = ImmutableMap.builder();
        exporterBuilder.put((Object)"PHOTOS", (Object)new FacebookPhotosExporter(appCredentials, monitor, (TemporaryPerJobDataStore)context.getService(TemporaryPerJobDataStore.class)));
        exporterBuilder.put((Object)"VIDEOS", (Object)new FacebookVideosExporter(appCredentials, monitor));
        this.exporterMap = exporterBuilder.build();
        this.initialized = true;
    }
}

