/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.facebook.photos;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.restfb.Connection;
import com.restfb.exception.FacebookGraphException;
import com.restfb.types.Album;
import com.restfb.types.Photo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.apache.commons.io.IOUtils;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.spi.transfer.types.CopyExceptionWithFailureReason;
import org.datatransferproject.transfer.ImageStreamProvider;
import org.datatransferproject.transfer.facebook.photos.FacebookPhotosInterface;
import org.datatransferproject.transfer.facebook.photos.RestFbFacebookPhotos;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.IdOnlyContainerResource;
import org.datatransferproject.types.common.models.photos.PhotoAlbum;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.photos.PhotosContainerResource;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class FacebookPhotosExporter
implements Exporter<TokensAndUrlAuthData, PhotosContainerResource> {
    private static final String ALBUM_TOKEN_PREFIX = "album:";
    static final String PHOTO_TOKEN_PREFIX = "media:";
    private final Monitor monitor;
    private final TemporaryPerJobDataStore store;
    private final ImageStreamProvider imageStreamProvider;
    private AppCredentials appCredentials;
    private FacebookPhotosInterface photosInterface;
    private final SimpleDateFormat exifDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");

    public FacebookPhotosExporter(AppCredentials appCredentials, Monitor monitor, TemporaryPerJobDataStore store) {
        this.appCredentials = appCredentials;
        this.monitor = monitor;
        this.store = store;
        this.imageStreamProvider = new ImageStreamProvider();
    }

    @VisibleForTesting
    FacebookPhotosExporter(AppCredentials appCredentials, FacebookPhotosInterface photosInterface, Monitor monitor, TemporaryPerJobDataStore store, ImageStreamProvider imageStreamProvider) {
        this.appCredentials = appCredentials;
        this.photosInterface = photosInterface;
        this.monitor = monitor;
        this.store = store;
        this.imageStreamProvider = imageStreamProvider;
    }

    public ExportResult<PhotosContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) throws CopyExceptionWithFailureReason {
        boolean paginationDataPresent;
        Preconditions.checkNotNull((Object)authData);
        if (!exportInformation.isPresent()) {
            return this.exportAlbums(authData, Optional.empty());
        }
        StringPaginationToken paginationToken = (StringPaginationToken)exportInformation.get().getPaginationData();
        ContainerResource containerResource = exportInformation.get().getContainerResource();
        boolean containerResourcePresent = containerResource != null;
        boolean bl = paginationDataPresent = paginationToken != null;
        if (!containerResourcePresent && paginationDataPresent && paginationToken.getToken().startsWith(ALBUM_TOKEN_PREFIX)) {
            return this.exportAlbums(authData, Optional.of(paginationToken));
        }
        if (containerResourcePresent && containerResource instanceof PhotosContainerResource) {
            PhotosContainerResource photosContainerResource = (PhotosContainerResource)containerResource;
            Preconditions.checkNotNull((Object)photosContainerResource.getAlbums());
            ContinuationData continuationData = new ContinuationData(null);
            for (PhotoAlbum album : photosContainerResource.getAlbums()) {
                continuationData.addContainerResource((ContainerResource)new IdOnlyContainerResource(album.getId()));
            }
            return new ExportResult(ExportResult.ResultType.CONTINUE, (DataModel)photosContainerResource, continuationData);
        }
        if (containerResourcePresent && containerResource instanceof IdOnlyContainerResource) {
            return this.exportPhotos(jobId, authData, (IdOnlyContainerResource)containerResource, Optional.ofNullable(paginationToken));
        }
        throw new IllegalStateException(String.format("Invalid state passed into FacebookPhotosExporter. ExportInformation: %s", exportInformation));
    }

    private ExportResult<PhotosContainerResource> exportAlbums(TokensAndUrlAuthData authData, Optional<StringPaginationToken> paginationData) throws CopyExceptionWithFailureReason {
        Optional<String> paginationToken = this.stripTokenPrefix(paginationData, ALBUM_TOKEN_PREFIX);
        Connection<Album> connection = this.getOrCreatePhotosInterface(authData).getAlbums(paginationToken);
        StringPaginationToken nextPageData = null;
        String token = connection.getAfterCursor();
        if (!Strings.isNullOrEmpty((String)token)) {
            nextPageData = new StringPaginationToken(ALBUM_TOKEN_PREFIX + token);
        }
        ContinuationData continuationData = new ContinuationData(nextPageData);
        List albums = connection.getData();
        if (albums.isEmpty()) {
            return new ExportResult(ExportResult.ResultType.END, null, null);
        }
        ArrayList<PhotoAlbum> exportAlbums = new ArrayList<PhotoAlbum>();
        for (Album album : albums) {
            exportAlbums.add(new PhotoAlbum(album.getId(), album.getName(), album.getDescription()));
            continuationData.addContainerResource((ContainerResource)new IdOnlyContainerResource(album.getId()));
        }
        return new ExportResult(ExportResult.ResultType.CONTINUE, (DataModel)new PhotosContainerResource(exportAlbums, null), continuationData);
    }

    private ExportResult<PhotosContainerResource> exportPhotos(UUID jobId, TokensAndUrlAuthData authData, IdOnlyContainerResource containerResource, Optional<StringPaginationToken> paginationData) throws CopyExceptionWithFailureReason {
        Optional<String> paginationToken = this.stripTokenPrefix(paginationData, PHOTO_TOKEN_PREFIX);
        String albumId = containerResource.getId();
        try {
            Connection<Photo> photoConnection = this.getOrCreatePhotosInterface(authData).getPhotos(albumId, paginationToken);
            List photos = photoConnection.getData();
            if (photos.isEmpty()) {
                return new ExportResult(ExportResult.ResultType.END, null);
            }
            ArrayList<PhotoModel> exportPhotos = new ArrayList<PhotoModel>();
            for (Photo photo : photos) {
                boolean photoWasGarbage;
                String url = ((Photo.Image)photo.getImages().get(0)).getSource();
                String fbid = photo.getId();
                if (null == url || url.isEmpty()) {
                    this.monitor.severe(() -> String.format("Source was missing or empty for photo %s", fbid), new Object[0]);
                    continue;
                }
                try {
                    photoWasGarbage = this.modifyExifAndStorePhoto(jobId, photo, url, photo.getId());
                }
                catch (IOException e) {
                    this.monitor.info(() -> String.format("Error while modifying exif or storing photo %s", fbid), new Object[]{e});
                    photoWasGarbage = true;
                }
                if (photoWasGarbage) continue;
                exportPhotos.add(new PhotoModel(String.format("%s.jpg", photo.getId()), photo.getId(), photo.getName(), "image/jpg", photo.getId(), albumId, true, photo.getCreatedTime()));
            }
            String token = photoConnection.getAfterCursor();
            if (Strings.isNullOrEmpty((String)token)) {
                return new ExportResult(ExportResult.ResultType.END, (DataModel)new PhotosContainerResource(null, exportPhotos));
            }
            StringPaginationToken nextPageData = new StringPaginationToken(PHOTO_TOKEN_PREFIX + token);
            ContinuationData continuationData = new ContinuationData((PaginationData)nextPageData);
            return new ExportResult(ExportResult.ResultType.CONTINUE, (DataModel)new PhotosContainerResource(null, exportPhotos), continuationData);
        }
        catch (FacebookGraphException e) {
            String message = e.getMessage();
            if (message != null && message.contains("code 100, subcode 33")) {
                this.monitor.info(() -> "Cannot find photos to export, skipping to the next bunch", new Object[]{e});
                return new ExportResult(ExportResult.ResultType.END, null);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean modifyExifAndStorePhoto(UUID jobId, Photo photo, String url, String blindedPhotoId) throws IOException {
        try (InputStream inputStream = this.imageStreamProvider.getConnection(url).getInputStream();){
            TiffImageMetadata exif;
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            if (bytes.length == 0) {
                boolean bl = true;
                return bl;
            }
            if (null == photo.getCreatedTime()) {
                try (ByteArrayInputStream unmodifiedInputStream2 = new ByteArrayInputStream(bytes);){
                    this.store.create(jobId, blindedPhotoId, (InputStream)unmodifiedInputStream2);
                }
                boolean unmodifiedInputStream2 = false;
                return unmodifiedInputStream2;
            }
            ImageMetadata metadata = Imaging.getMetadata((byte[])bytes);
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            TiffOutputSet outputSet = null;
            if (null != jpegMetadata && null != (exif = jpegMetadata.getExif())) {
                outputSet = exif.getOutputSet();
            }
            if (null == outputSet) {
                outputSet = new TiffOutputSet();
            }
            TiffOutputDirectory exifDirectory = outputSet.getOrCreateExifDirectory();
            exifDirectory.removeField((TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
            exifDirectory.add(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL, new String[]{this.exifDateFormat.format(photo.getCreatedTime())});
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(bytes.length);){
                new ExifRewriter().updateExifMetadataLossless(bytes, (OutputStream)outputStream, outputSet);
                try (ByteArrayInputStream modifiedInputStream = new ByteArrayInputStream(outputStream.toByteArray());){
                    this.store.create(jobId, blindedPhotoId, (InputStream)modifiedInputStream);
                    return false;
                }
            }
        }
        catch (ImageReadException | ImageWriteException e) {
            this.monitor.severe(() -> String.format("There was an issue when modifying the exif data of %s", photo.getId()), new Object[]{e});
            return true;
        }
    }

    private Optional<String> stripTokenPrefix(Optional<StringPaginationToken> paginationData, String prefix) {
        Optional<String> paginationToken = Optional.empty();
        if (paginationData.isPresent()) {
            String token = paginationData.get().getToken();
            Preconditions.checkArgument((boolean)token.startsWith(prefix), (Object)("Invalid pagination token " + token));
            paginationToken = Optional.of(token.substring(prefix.length()));
        }
        return paginationToken;
    }

    private synchronized FacebookPhotosInterface getOrCreatePhotosInterface(TokensAndUrlAuthData authData) {
        return this.photosInterface == null ? this.makePhotosInterface(authData) : this.photosInterface;
    }

    private synchronized FacebookPhotosInterface makePhotosInterface(TokensAndUrlAuthData authData) {
        this.photosInterface = new RestFbFacebookPhotos(authData, this.appCredentials);
        return this.photosInterface;
    }
}

