/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.flickr.media;

import com.flickr4java.flickr.Flickr;
import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.REST;
import com.flickr4java.flickr.RequestContext;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.auth.Auth;
import com.flickr4java.flickr.photosets.Photoset;
import com.flickr4java.flickr.photosets.PhotosetsInterface;
import com.flickr4java.flickr.uploader.UploadMetaData;
import com.flickr4java.flickr.uploader.Uploader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.RateLimiter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.flickr.photos.FlickrTempPhotoData;
import org.datatransferproject.datatransfer.flickr.photos.FlickrUtils;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.spi.transfer.types.DestinationMemoryFullException;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.media.MediaAlbum;
import org.datatransferproject.types.common.models.media.MediaContainerResource;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.videos.VideoModel;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.AuthData;
import org.datatransferproject.types.transfer.serviceconfig.TransferServiceConfig;

public class FlickrMediaImporter
implements Importer<AuthData, MediaContainerResource> {
    @VisibleForTesting
    static final String ORIGINAL_ALBUM_PREFIX = "original-album-";
    private final TemporaryPerJobDataStore jobStore;
    private final Flickr flickr;
    private final Uploader uploader;
    private final ImageStreamProvider imageStreamProvider;
    private final PhotosetsInterface photosetsInterface;
    private final Monitor monitor;
    private final RateLimiter perUserRateLimiter;

    public FlickrMediaImporter(AppCredentials appCredentials, TemporaryPerJobDataStore jobStore, Monitor monitor, TransferServiceConfig serviceConfig) {
        this.jobStore = jobStore;
        this.flickr = new Flickr(appCredentials.getKey(), appCredentials.getSecret(), (Transport)new REST());
        this.uploader = this.flickr.getUploader();
        this.imageStreamProvider = new ImageStreamProvider();
        this.photosetsInterface = this.flickr.getPhotosetsInterface();
        this.monitor = monitor;
        this.perUserRateLimiter = serviceConfig.getPerUserRateLimiter();
    }

    @VisibleForTesting
    FlickrMediaImporter(Flickr flickr, TemporaryPerJobDataStore jobstore, ImageStreamProvider imageStreamProvider, Monitor monitor, TransferServiceConfig serviceConfig) {
        this.flickr = flickr;
        this.imageStreamProvider = imageStreamProvider;
        this.jobStore = jobstore;
        this.uploader = flickr.getUploader();
        this.photosetsInterface = flickr.getPhotosetsInterface();
        this.monitor = monitor;
        this.perUserRateLimiter = serviceConfig.getPerUserRateLimiter();
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentExecutor, AuthData authData, MediaContainerResource data) throws Exception, IOException {
        Auth auth;
        try {
            auth = FlickrUtils.getAuth(authData, this.flickr);
        }
        catch (FlickrException e) {
            return new ImportResult((Throwable)e);
        }
        RequestContext.getRequestContext().setAuth(auth);
        Preconditions.checkArgument((data.getAlbums() != null || data.getPhotos() != null || data.getVideos() != null ? 1 : 0) != 0, (Object)"Error: There is no data to import");
        if (data.getAlbums() != null) {
            this.storeAlbums(jobId, data.getAlbums());
        }
        if (data.getPhotos() != null) {
            for (PhotoModel photo : data.getPhotos()) {
                try {
                    this.importSinglePhoto(idempotentExecutor, jobId, photo);
                }
                catch (FlickrException e) {
                    if (e.getMessage().contains("Upload limit reached")) {
                        throw new DestinationMemoryFullException("Flickr destination memory reached", (Throwable)e);
                    }
                    if (e.getMessage().contains("Photo already in set")) continue;
                    throw new IOException(e);
                }
            }
        }
        if (data.getVideos() != null) {
            for (VideoModel video : data.getVideos()) {
                try {
                    this.importSingleVideo(idempotentExecutor, jobId, video);
                }
                catch (FlickrException e) {
                    if (e.getMessage().contains("Upload limit reached")) {
                        throw new DestinationMemoryFullException("Flickr destination memory reached", (Throwable)e);
                    }
                    if (e.getMessage().contains("Photo already in set")) continue;
                    throw new IOException(e);
                }
            }
        }
        return new ImportResult(ImportResult.ResultType.OK);
    }

    private void storeAlbums(UUID jobId, Collection<MediaAlbum> albums) throws IOException {
        for (MediaAlbum album : albums) {
            this.jobStore.create(jobId, ORIGINAL_ALBUM_PREFIX + album.getId(), (DataModel)new FlickrTempPhotoData(album.getName(), album.getDescription()));
        }
    }

    private void importSinglePhoto(IdempotentImportExecutor idempotentExecutor, UUID id, PhotoModel photo) throws Exception {
        String photoId = (String)((Object)idempotentExecutor.executeAndSwallowIOExceptions(photo.getIdempotentId(), photo.getTitle(), () -> this.uploadPhoto(photo, id)));
        this.monitor.debug(() -> String.format("photo - %s has favorite state %b ", photo.getTitle(), photo.getFavoriteInfo().getFavorited()), new Object[0]);
        if (photoId == null) {
            return;
        }
        String oldAlbumId = photo.getAlbumId();
        if (Strings.isNullOrEmpty((String)oldAlbumId)) {
            return;
        }
        this.createOrAddToAlbum(idempotentExecutor, id, photo.getAlbumId(), photoId);
    }

    private void importSingleVideo(IdempotentImportExecutor idempotentExecutor, UUID id, VideoModel video) throws Exception {
        String videoId = (String)((Object)idempotentExecutor.executeAndSwallowIOExceptions(video.getIdempotentId(), video.getName(), () -> this.uploadVideo(video, id)));
        if (videoId == null) {
            return;
        }
        String oldAlbumId = video.getAlbumId();
        if (Strings.isNullOrEmpty((String)oldAlbumId)) {
            return;
        }
        this.createOrAddToAlbum(idempotentExecutor, id, video.getAlbumId(), videoId);
    }

    private void createOrAddToAlbum(IdempotentImportExecutor idempotentExecutor, UUID jobId, String oldAlbumId, String photoId) throws Exception {
        if (idempotentExecutor.isKeyCached(oldAlbumId)) {
            String newAlbumId = (String)((Object)idempotentExecutor.getCachedValue(oldAlbumId));
            this.photosetsInterface.addPhoto(newAlbumId, photoId);
        } else {
            this.createAlbum(idempotentExecutor, jobId, oldAlbumId, photoId);
        }
    }

    private void createAlbum(IdempotentImportExecutor idempotentExecutor, UUID jobId, String oldAlbumId, String firstPhotoId) throws Exception {
        FlickrTempPhotoData album = (FlickrTempPhotoData)this.jobStore.findData(jobId, ORIGINAL_ALBUM_PREFIX + oldAlbumId, FlickrTempPhotoData.class);
        Preconditions.checkNotNull((Object)((Object)album), (Object)("Album not found: " + oldAlbumId));
        idempotentExecutor.executeAndSwallowIOExceptions(oldAlbumId, album.getName(), () -> {
            String albumName = Strings.isNullOrEmpty((String)album.getName()) ? "untitled" : album.getName();
            String albumDescription = FlickrMediaImporter.cleanString(album.getDescription());
            this.perUserRateLimiter.acquire();
            Photoset photoset = this.photosetsInterface.create(albumName, albumDescription, firstPhotoId);
            this.monitor.debug(() -> String.format("Flickr importer created album: %s", new Object[]{album}), new Object[0]);
            return photoset.getId();
        });
    }

    private String uploadPhoto(PhotoModel photo, UUID jobId) throws IOException, FlickrException {
        InputStream inStream;
        if (photo.isInTempStore()) {
            TemporaryPerJobDataStore.InputStreamWrapper streamWrapper = this.jobStore.getStream(jobId, photo.getFetchableUrl());
            inStream = streamWrapper.getStream();
        } else {
            inStream = this.imageStreamProvider.get(photo.getFetchableUrl());
        }
        String photoTitle = Strings.isNullOrEmpty((String)photo.getTitle()) ? "" : photo.getTitle();
        String photoDescription = FlickrMediaImporter.cleanString(photo.getDescription());
        UploadMetaData uploadMetaData = new UploadMetaData().setAsync(false).setPublicFlag(false).setFriendFlag(false).setFamilyFlag(false).setTitle(photoTitle).setDescription(photoDescription);
        this.perUserRateLimiter.acquire();
        String uploadResult = this.uploader.upload(inStream, uploadMetaData);
        inStream.close();
        this.monitor.debug(() -> String.format("%s: Flickr importer uploading photo: %s", jobId, photo), new Object[0]);
        return uploadResult;
    }

    private String uploadVideo(VideoModel video, UUID jobId) throws IOException, FlickrException {
        InputStream inStream;
        if (video.isInTempStore()) {
            TemporaryPerJobDataStore.InputStreamWrapper streamWrapper = this.jobStore.getStream(jobId, video.getFetchableUrl());
            inStream = streamWrapper.getStream();
        } else {
            inStream = this.imageStreamProvider.get(video.getFetchableUrl());
        }
        String videoTitle = Strings.isNullOrEmpty((String)video.getName()) ? "" : video.getName();
        String videoDescription = FlickrMediaImporter.cleanString(video.getDescription());
        UploadMetaData uploadMetaData = new UploadMetaData().setAsync(false).setPublicFlag(false).setFriendFlag(false).setFamilyFlag(false).setTitle(videoTitle).setDescription(videoDescription);
        this.perUserRateLimiter.acquire();
        String uploadResult = this.uploader.upload(inStream, uploadMetaData);
        inStream.close();
        this.monitor.debug(() -> String.format("%s: Flickr importer uploading video: %s", jobId, video), new Object[0]);
        return uploadResult;
    }

    private static String cleanString(String string) {
        return Strings.isNullOrEmpty((String)string) ? "" : string;
    }

    @VisibleForTesting
    class ImageStreamProvider {
        ImageStreamProvider() {
        }

        public BufferedInputStream get(String urlStr) throws IOException {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            return new BufferedInputStream(conn.getInputStream());
        }
    }
}

